/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.connection;

import java.util.Optional;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.internal.connection.AbstractConnectionProviderWrapper;
import org.mule.runtime.core.internal.connection.ConnectionProviderWrapper;
import org.mule.runtime.core.internal.retry.ReconnectionConfig;

public class ConfigNameResolverConnectionProviderWrapper<C>
extends AbstractConnectionProviderWrapper<C> {
    private final String ownerConfigName;
    private final ReconnectionConfig reconnectionConfig;

    public ConfigNameResolverConnectionProviderWrapper(ConnectionProvider<C> delegate, ReconnectionConfig reconnectionConfig, String ownerConfigName) {
        super(delegate);
        this.reconnectionConfig = reconnectionConfig;
        this.ownerConfigName = ownerConfigName;
    }

    @Override
    public C connect() throws ConnectionException {
        return this.getDelegate().connect();
    }

    @Override
    public RetryPolicyTemplate getRetryPolicyTemplate() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getRetryPolicyTemplate() : super.getRetryPolicyTemplate();
    }

    @Override
    public Optional<ReconnectionConfig> getReconnectionConfig() {
        ConnectionProvider delegate = this.getDelegate();
        return delegate instanceof ConnectionProviderWrapper ? ((ConnectionProviderWrapper)delegate).getReconnectionConfig() : Optional.ofNullable(this.reconnectionConfig);
    }

    @Override
    public Optional<String> getOwnerConfigName() {
        return Optional.of(this.ownerConfigName);
    }
}

