/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.api.dsl.model.metadata;

import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.ArrayType;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.Typed;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.core.api.util.StringUtils;
import org.mule.runtime.core.internal.util.cache.CacheIdBuilderAdapter;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class ComponentBasedIdHelper {
    static Optional<String> getModelNameAst(ComponentAst component) {
        Optional<NamedObject> namedObjectModel = component.getModel(NamedObject.class);
        if (namedObjectModel.isPresent()) {
            try {
                return namedObjectModel.map(NamedObject::getName);
            }
            catch (IllegalArgumentException e) {
                return Optional.empty();
            }
        }
        Optional<Typed> typedObjectModel = component.getModel(Typed.class);
        if (typedObjectModel.isPresent()) {
            return typedObjectModel.map(t -> ExtensionMetadataTypeUtils.getId(t.getType()).toString());
        }
        return Optional.empty();
    }

    static String sourceElementName(ComponentAst element) {
        return ComponentBasedIdHelper.getModelNameAst(element).map(modelName -> element.getIdentifier().getNamespace() + ":" + modelName + element.getComponentId().map(n -> "[" + n + "]").orElse("")).orElseGet(() -> element.getIdentifier().toString());
    }

    static String sourceElementNameFromSimpleValue(ComponentAst element) {
        return ComponentBasedIdHelper.getModelNameAst(element).map(modelName -> element.getIdentifier().getNamespace() + ":" + modelName).orElseGet(() -> element.getIdentifier().toString());
    }

    static Optional<String> resolveConfigName(ComponentAst elementModel) {
        return Optional.ofNullable(elementModel.getParameter("General", "config-ref")).map(param -> param.getResolvedRawValue());
    }

    @Deprecated
    public static int computeHashFor(ComponentParameterAst componentParameterAst) {
        return DeprecatedParameterVisitorFunctions.computeHashFor(componentParameterAst);
    }

    static <K> K computeIdFor(ComponentAst containerComponent, ComponentParameterAst componentParameterAst, Supplier<CacheIdBuilderAdapter<K>> cacheIdBuilderSupplier) {
        return (K)ParameterVisitorFunctions.computeIdFor(containerComponent, componentParameterAst, cacheIdBuilderSupplier);
    }

    @Deprecated
    private static class DeprecatedParameterVisitorFunctions {
        private StringBuilder hashBuilder = new StringBuilder();
        private final Function<String, Void> leftFunction = this::hashForLeft;
        private final Function<Object, Void> rightFunction = this::hashForRight;

        private static int computeHashFor(ComponentParameterAst parameter) {
            return Objects.hashCode(new DeprecatedParameterVisitorFunctions((ComponentParameterAst)parameter).hashBuilder.toString());
        }

        private DeprecatedParameterVisitorFunctions(ComponentParameterAst startingParameter) {
            startingParameter.getValue().reduce(this.leftFunction, this.rightFunction);
        }

        private Void hashForLeft(String s) {
            this.hashBuilder.append(s);
            return null;
        }

        private Void hashForRight(Object o) {
            if (o instanceof ComponentAst) {
                ComponentAst c = (ComponentAst)o;
                c.getParameters().stream().filter(componentParameterAst -> componentParameterAst.getValue().getValue().isPresent()).sorted(Comparator.comparing(p -> p.getModel().getName())).forEach(p -> {
                    this.hashBuilder.append(p.getModel().getName());
                    if (p.getModel().getType() instanceof ArrayType) {
                        this.hashForList((Collection)p.getValue().getRight());
                    } else {
                        p.getValue().reduce(this.leftFunction, this.rightFunction);
                    }
                });
            } else {
                this.hashBuilder.append(o);
            }
            return null;
        }

        private void hashForList(Collection<ComponentAst> collection) {
            collection.forEach(c -> {
                ComponentParameterAst parameterAst = c.getParameter("General", "value");
                if (parameterAst == null) {
                    this.rightFunction.apply(c);
                } else {
                    parameterAst.getValue().reduce(this.leftFunction, this.rightFunction);
                }
            });
        }
    }

    private static class ParameterVisitorFunctions<K> {
        private final Supplier<CacheIdBuilderAdapter<K>> idBuilderSupplier;
        private final CacheIdBuilderAdapter<K> idBuilder;

        private static <T> T computeIdFor(ComponentAst containerComponent, ComponentParameterAst parameter, Supplier<CacheIdBuilderAdapter<T>> cacheIdBuilderSupplier) {
            return (T)new ParameterVisitorFunctions<K>((ComponentAst)containerComponent, (ComponentParameterAst)parameter, cacheIdBuilderSupplier).idBuilder.build();
        }

        private static <T> T computeIdFor(ComponentAst componentAst, Supplier<CacheIdBuilderAdapter<T>> cacheIdBuilderSupplier) {
            return (T)new ParameterVisitorFunctions<K>((ComponentAst)componentAst, cacheIdBuilderSupplier).idBuilder.build();
        }

        private ParameterVisitorFunctions(ComponentAst containerComponent, ComponentParameterAst parameterAst, Supplier<CacheIdBuilderAdapter<K>> cacheKeyBuilderSupplier) {
            String name = parameterAst.getGenerationInformation().getSyntax().map(s -> {
                if (StringUtils.isEmpty(s.getElementName())) {
                    return s.getAttributeName();
                }
                return s.getPrefix() + ":" + s.getElementName();
            }).orElse(containerComponent.getIdentifier().getNamespace() + ":" + parameterAst.getModel().getName());
            this.idBuilderSupplier = cacheKeyBuilderSupplier;
            this.idBuilder = this.idBuilderSupplier.get().withSourceElementName(name).withHashValue(Objects.hashCode(name));
            parameterAst.getValue().reduce(v -> this.hashForLeft(parameterAst.getRawValue()), this::hashForRight);
        }

        private ParameterVisitorFunctions(ComponentAst component, Supplier<CacheIdBuilderAdapter<K>> cacheKeyBuilderSupplier) {
            String name = component.getIdentifier().toString();
            this.idBuilderSupplier = cacheKeyBuilderSupplier;
            this.idBuilder = this.idBuilderSupplier.get().withSourceElementName(name).withHashValue(Objects.hashCode(name));
            this.idBuilder.containing(component.getParameters().stream().filter(componentParameterAst -> componentParameterAst.getValue().getValue().isPresent()).map(p -> ParameterVisitorFunctions.computeIdFor(component, p, cacheKeyBuilderSupplier)).collect(Collectors.toList()));
        }

        private Void hashForLeft(String s) {
            this.idBuilder.withHashValue(Objects.hashCode(s));
            return null;
        }

        private Void hashForRight(Object o) {
            if (o instanceof Collection) {
                Collection collection = (Collection)o;
                this.idBuilder.containing(collection.stream().map(e -> ParameterVisitorFunctions.computeIdFor(e, this.idBuilderSupplier)).collect(Collectors.toList()));
            } else if (o instanceof ComponentAst) {
                ComponentAst c = (ComponentAst)o;
                this.idBuilder.containing(c.getParameters().stream().filter(componentParameterAst -> componentParameterAst.getValue().getValue().isPresent()).sorted(Comparator.comparing(p -> p.getModel().getName())).map(p -> ParameterVisitorFunctions.computeIdFor(c, p, this.idBuilderSupplier)).collect(Collectors.toList()));
            } else if (o != null) {
                this.idBuilder.withHashValue(Objects.hashCode(o.toString()));
            }
            return null;
        }
    }
}

