/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.artifact.api.classloader.net;

import java.net.URL;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import org.mule.api.annotation.NoInstantiate;
import org.mule.runtime.core.api.util.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.net.www.protocol.jar.Handler;

@NoInstantiate
public final class MuleUrlStreamHandlerFactory
implements URLStreamHandlerFactory {
    private static final String HANDLER_PKGS_SYSTEM_PROPERTY = "java.protocol.handler.pkgs";
    private static final Logger log = LoggerFactory.getLogger(MuleUrlStreamHandlerFactory.class);
    private static Map registry = Collections.synchronizedMap(new HashMap());

    public static synchronized void installUrlStreamHandlerFactory() {
        block2: {
            try {
                URL.setURLStreamHandlerFactory(new MuleUrlStreamHandlerFactory());
            }
            catch (Error err) {
                if (!log.isDebugEnabled()) break block2;
                log.debug("Custom MuleUrlStreamHandlerFactory already registered", (Throwable)err);
            }
        }
    }

    public static void registerHandler(String protocol, URLStreamHandler handler) {
        registry.put(protocol, handler);
    }

    @Override
    public URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandler handler = (URLStreamHandler)registry.get(protocol);
        if (handler == null) {
            handler = this.defaultHandlerCreateStrategy(protocol);
        }
        return handler;
    }

    private URLStreamHandler defaultHandlerCreateStrategy(String protocol) {
        String packagePrefixList = System.getProperty(HANDLER_PKGS_SYSTEM_PROPERTY, "");
        if (!packagePrefixList.endsWith("|")) {
            packagePrefixList = packagePrefixList + "|sun.net.www.protocol";
        }
        StringTokenizer tokenizer = new StringTokenizer(packagePrefixList, "|");
        URLStreamHandler handler = null;
        while (handler == null && tokenizer.hasMoreTokens()) {
            String packagePrefix = tokenizer.nextToken().trim();
            String className = packagePrefix + "." + protocol + ".Handler";
            if ("sun.net.www.protocol.jar.Handler".equals(className)) {
                handler = new Handler();
                continue;
            }
            try {
                handler = (URLStreamHandler)ClassUtils.instantiateClass(className, new Object[0]);
            }
            catch (Exception exception) {}
        }
        return handler;
    }
}

