/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.config;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.lifecycle.Disposable;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.properties.api.ConfigurationPropertiesProvider;
import org.mule.runtime.properties.api.ConfigurationProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeConfigurationPropertiesProvider
implements ConfigurationPropertiesProvider,
Initialisable,
Disposable {
    private static final Logger LOGGER = LoggerFactory.getLogger(CompositeConfigurationPropertiesProvider.class);
    private final List<ConfigurationPropertiesProvider> configurationPropertiesProviders;
    private boolean initialized = false;
    private boolean disposed = false;

    @Override
    public void dispose() {
        if (this.disposed) {
            return;
        }
        LifecycleUtils.disposeIfNeeded(this.configurationPropertiesProviders, LOGGER);
        this.disposed = true;
    }

    @Override
    public void initialise() throws InitialisationException {
        if (this.initialized) {
            return;
        }
        for (ConfigurationPropertiesProvider configurationPropertiesProvider : this.configurationPropertiesProviders) {
            LifecycleUtils.initialiseIfNeeded(configurationPropertiesProvider);
        }
        this.initialized = true;
    }

    public CompositeConfigurationPropertiesProvider(List<ConfigurationPropertiesProvider> configurationPropertiesProviders) {
        this.configurationPropertiesProviders = configurationPropertiesProviders;
    }

    @Override
    public Optional<? extends ConfigurationProperty> provide(String configurationAttributeKey) {
        for (ConfigurationPropertiesProvider configurationPropertiesProvider : this.configurationPropertiesProviders) {
            Optional<? extends ConfigurationProperty> configurationAttribute = configurationPropertiesProvider.provide(configurationAttributeKey);
            if (!configurationAttribute.isPresent()) continue;
            return configurationAttribute;
        }
        return Optional.empty();
    }

    @Override
    public String getDescription() {
        StringBuilder stringBuilder = new StringBuilder("configuration-attribute provider composed of (");
        for (ConfigurationPropertiesProvider configurationPropertiesProvider : this.configurationPropertiesProviders) {
            stringBuilder.append(configurationPropertiesProvider.getDescription());
            stringBuilder.append(", ");
        }
        stringBuilder.replace(stringBuilder.length() - 2, stringBuilder.length(), "");
        return stringBuilder.append(")").toString();
    }
}

