/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.privileged.routing;

import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import org.mule.runtime.api.message.Error;
import org.mule.runtime.api.message.Message;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.privileged.exception.EventProcessingException;

public final class RoutingResult {
    private final Map<String, Message> successfulRoutesResultMap;
    private final Map<String, Error> failedRoutesErrorMap;
    private Map<String, Pair<Error, EventProcessingException>> failedRoutesErrorWithExceptionMap;

    public RoutingResult(Map<String, Message> successfulRoutesResultMap, Map<String, Error> failedRoutesErrorMap) {
        this.successfulRoutesResultMap = Collections.unmodifiableMap(successfulRoutesResultMap);
        this.failedRoutesErrorMap = Collections.unmodifiableMap(failedRoutesErrorMap);
        this.failedRoutesErrorWithExceptionMap = Collections.emptyMap();
    }

    public static RoutingResult routingResultWithException(Map<String, Message> successfulRoutesResultMap, Map<String, Pair<Error, EventProcessingException>> failedRoutesErrorWithExceptionMap) {
        RoutingResult routingResult = new RoutingResult(successfulRoutesResultMap, Collections.emptyMap());
        routingResult.setFailedRoutesErrorWithExceptionMap(failedRoutesErrorWithExceptionMap);
        return routingResult;
    }

    private void setFailedRoutesErrorWithExceptionMap(Map<String, Pair<Error, EventProcessingException>> failedRoutesErrorWithExceptionMap) {
        this.failedRoutesErrorWithExceptionMap = failedRoutesErrorWithExceptionMap;
    }

    public Map<String, Message> getResults() {
        return this.successfulRoutesResultMap;
    }

    public Map<String, Error> getFailures() {
        if (!this.failedRoutesErrorWithExceptionMap.isEmpty()) {
            return this.failedRoutesErrorWithExceptionMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, pair -> (Error)((Pair)pair.getValue()).getFirst()));
        }
        return this.failedRoutesErrorMap;
    }

    public Map<String, Pair<Error, EventProcessingException>> getFailuresWithExceptionInfo() {
        return this.failedRoutesErrorWithExceptionMap;
    }
}

