/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.lang.reflect.Type;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.connection.HasConnectionProviderModels;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.construct.HasConstructModels;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.HasOperationModels;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.HasSourceModels;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.ExtensionWalker;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.internal.model.ApplicationModel;
import org.mule.runtime.core.api.source.scheduler.CronScheduler;
import org.mule.runtime.core.api.source.scheduler.FixedFrequencyScheduler;
import org.mule.runtime.dsl.api.component.config.ComponentConfiguration;
import org.mule.runtime.dsl.internal.component.config.InternalComponentConfiguration;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

class ConfigurationBasedElementModelFactory {
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();
    private final Map<ExtensionModel, DslSyntaxResolver> resolvers;
    private ExtensionModel currentExtension;
    private DslSyntaxResolver dsl;

    ConfigurationBasedElementModelFactory(Map<ExtensionModel, DslSyntaxResolver> resolvers) {
        this.resolvers = resolvers;
    }

    public <T> Optional<DslElementModel<T>> create(ComponentConfiguration configuration) {
        return Optional.ofNullable(this.createIdentifiedElement(configuration));
    }

    private DslElementModel createIdentifiedElement(final ComponentConfiguration configuration) {
        final ComponentIdentifier identifier = configuration.getIdentifier();
        Optional<Map.Entry> entry = this.resolvers.entrySet().stream().filter(e -> ((ExtensionModel)e.getKey()).getXmlDslModel().getPrefix().equals(identifier.getNamespace())).findFirst();
        if (!entry.isPresent()) {
            return null;
        }
        this.currentExtension = (ExtensionModel)entry.get().getKey();
        this.dsl = (DslSyntaxResolver)entry.get().getValue();
        final Reference elementModel = new Reference();
        new ExtensionWalker(){

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve(model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).filter(elementId -> elementId.equals(identifier)).ifPresent(elementId -> {
                    DslElementModel.Builder<ConfigurationModel> builder = DslElementModel.builder().withModel(model).withDsl(elementDsl).withConfig(configuration);
                    ConfigurationBasedElementModelFactory.this.addConnectionProvider(model, ConfigurationBasedElementModelFactory.this.dsl, builder, configuration);
                    ConfigurationBasedElementModelFactory.this.enrichElementModel(model, elementDsl, configuration, builder);
                    elementModel.set(builder.build());
                    this.stop();
                });
            }

            @Override
            protected void onConnectionProvider(HasConnectionProviderModels owner, ConnectionProviderModel model) {
                DslElementSyntax providerDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve(model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(providerDsl).filter(elementId -> elementId.equals(identifier)).ifPresent(elementId -> {
                    elementModel.set(ConfigurationBasedElementModelFactory.this.createConnectionProviderModel(model, providerDsl, configuration));
                    this.stop();
                });
            }

            @Override
            protected void onConstruct(HasConstructModels owner, ConstructModel model) {
                this.onComponentModel(model);
            }

            @Override
            protected void onOperation(HasOperationModels owner, OperationModel model) {
                this.onComponentModel(model);
            }

            @Override
            protected void onSource(HasSourceModels owner, SourceModel model) {
                this.onComponentModel(model);
            }

            private void onComponentModel(ComponentModel model) {
                DslElementSyntax elementDsl = ConfigurationBasedElementModelFactory.this.dsl.resolve(model);
                ConfigurationBasedElementModelFactory.this.getIdentifier(elementDsl).filter(elementId -> elementId.equals(identifier)).ifPresent(elementId -> {
                    elementModel.set(ConfigurationBasedElementModelFactory.this.createElementModel(model, elementDsl, configuration).build());
                    this.stop();
                });
            }
        }.walk(this.currentExtension);
        if (elementModel.get() == null) {
            this.resolveBasedOnTypes(configuration).ifPresent(elementModel::set);
        }
        return (DslElementModel)elementModel.get();
    }

    private Optional<DslElementModel<ObjectType>> resolveBasedOnTypes(ComponentConfiguration configuration) {
        return this.currentExtension.getTypes().stream().map(type -> this.resolveBasedOnType((ObjectType)type, configuration, (Deque<String>)new ArrayDeque<String>())).filter(Optional::isPresent).map(Optional::get).findFirst();
    }

    private void withStackControl(Deque<String> typeResolvingStack, String stackId, Runnable action) {
        if (!typeResolvingStack.contains(stackId)) {
            typeResolvingStack.push(stackId);
            action.run();
            typeResolvingStack.pop();
        }
    }

    private Optional<DslElementModel<ObjectType>> resolveBasedOnType(ObjectType type, ComponentConfiguration configuration, Deque<String> typeResolvingStack) {
        Optional<ComponentIdentifier> elementIdentifier;
        Optional<DslElementSyntax> typeDsl = this.dsl.resolve(type);
        if (typeDsl.isPresent() && (elementIdentifier = this.getIdentifier(typeDsl.get())).isPresent() && elementIdentifier.get().equals(configuration.getIdentifier())) {
            DslElementModel.Builder<ObjectType> typeBuilder = DslElementModel.builder().withModel(type).withDsl(typeDsl.get()).withConfig(configuration);
            ExtensionMetadataTypeUtils.getId(type).ifPresent(id -> this.withStackControl(typeResolvingStack, (String)id, () -> this.populateObjectFields(type, configuration, (DslElementSyntax)typeDsl.get(), typeBuilder, typeResolvingStack)));
            return Optional.of(typeBuilder.build());
        }
        return Optional.empty();
    }

    private void populateObjectFields(ObjectType type, ComponentConfiguration configuration, DslElementSyntax typeDsl, DslElementModel.Builder typeBuilder, Deque<String> typeResolvingStack) {
        type.getFields().forEach(field -> {
            if (field.getValue() instanceof ObjectType && field.getAnnotation(FlattenedTypeAnnotation.class).isPresent()) {
                ((ObjectType)field.getValue()).getFields().forEach(nested -> {
                    String name = MetadataTypeUtils.getLocalPart(nested);
                    typeDsl.getContainedElement(name).ifPresent(fieldDsl -> nested.getValue().accept(this.getComponentChildVisitor(typeBuilder, configuration, (MetadataType)nested, name, (DslElementSyntax)fieldDsl, ExtensionModelUtils.getDefaultValue(name, field.getValue()), typeResolvingStack)));
                });
            } else {
                String name = MetadataTypeUtils.getLocalPart(field);
                typeDsl.getContainedElement(name).ifPresent(fieldDsl -> field.getValue().accept(this.getComponentChildVisitor(typeBuilder, configuration, (MetadataType)field, name, (DslElementSyntax)fieldDsl, ExtensionModelUtils.getDefaultValue(name, type), typeResolvingStack)));
            }
        });
    }

    private Multimap<ComponentIdentifier, ComponentConfiguration> getNestedComponents(ComponentConfiguration configuration) {
        ArrayListMultimap result = ArrayListMultimap.create();
        configuration.getNestedComponents().forEach(arg_0 -> ConfigurationBasedElementModelFactory.lambda$getNestedComponents$8((Multimap)result, arg_0));
        return result;
    }

    private MetadataTypeVisitor getComponentChildVisitor(final DslElementModel.Builder typeBuilder, final ComponentConfiguration configuration, final MetadataType model, final String name, final DslElementSyntax modelDsl, final Optional<String> defaultValue, final Deque<String> typeResolvingStack) {
        final Map<String, String> parameters = configuration.getParameters();
        return new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                DslElementModel.Builder<MetadataType> elementBuilder = DslElementModel.builder().withModel(model).withDsl(modelDsl);
                Optional identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                String value = (String)parameters.get(name);
                if (StringUtils.isBlank((CharSequence)value)) {
                    if (identifier.isPresent()) {
                        ComponentConfiguration nested = ConfigurationBasedElementModelFactory.this.getSingleComponentConfiguration((Multimap<ComponentIdentifier, ComponentConfiguration>)ConfigurationBasedElementModelFactory.this.getNestedComponents(configuration), identifier);
                        if (nested != null && nested.getValue().isPresent() && !StringUtils.isBlank((CharSequence)nested.getValue().get())) {
                            value = nested.getValue().get().trim();
                        }
                    } else if (defaultValue.isPresent()) {
                        value = (String)defaultValue.get();
                        elementBuilder.isExplicitInDsl(false);
                    }
                }
                if (!StringUtils.isBlank((CharSequence)value)) {
                    typeBuilder.containing(elementBuilder.withValue(value).build());
                }
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                ComponentConfiguration fieldComponent;
                Optional identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (identifier.isPresent() && (fieldComponent = ConfigurationBasedElementModelFactory.this.getSingleComponentConfiguration((Multimap<ComponentIdentifier, ComponentConfiguration>)ConfigurationBasedElementModelFactory.this.getNestedComponents(configuration), identifier)) != null) {
                    DslElementModel.Builder<MetadataType> list = DslElementModel.builder().withModel(model).withDsl(modelDsl).withConfig(fieldComponent);
                    modelDsl.getGeneric(arrayType.getType()).ifPresent(itemdsl -> {
                        ComponentIdentifier itemIdentifier = (ComponentIdentifier)ConfigurationBasedElementModelFactory.this.getIdentifier(itemdsl).get();
                        fieldComponent.getNestedComponents().forEach(c -> {
                            if (c.getIdentifier().equals(itemIdentifier)) {
                                ConfigurationBasedElementModelFactory.this.getComponentChildVisitor(list, c, arrayType.getType(), "value", itemdsl, defaultValue, typeResolvingStack);
                            }
                        });
                    });
                    typeBuilder.containing(list.build());
                    return;
                }
                defaultValue.ifPresent(s -> typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue((String)defaultValue.get()).isExplicitInDsl(false).build()));
            }

            @Override
            public void visitObject(ObjectType objectType) {
                Optional identifier = ConfigurationBasedElementModelFactory.this.getIdentifier(modelDsl);
                if (identifier.isPresent()) {
                    ComponentConfiguration fieldComponent = ConfigurationBasedElementModelFactory.this.getSingleComponentConfiguration((Multimap<ComponentIdentifier, ComponentConfiguration>)ConfigurationBasedElementModelFactory.this.getNestedComponents(configuration), identifier);
                    if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                        typeBuilder.containing(ConfigurationBasedElementModelFactory.this.createMapElement(objectType, modelDsl, fieldComponent));
                        return;
                    }
                    String value = (fieldComponent = fieldComponent == null ? configuration : fieldComponent).getParameters().get(modelDsl.getAttributeName());
                    if (!StringUtils.isBlank((CharSequence)value)) {
                        typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue(value).build());
                    } else {
                        ConfigurationBasedElementModelFactory.this.resolveBasedOnType(objectType, fieldComponent, typeResolvingStack).ifPresent(typeBuilder::containing);
                    }
                    return;
                }
                defaultValue.ifPresent(s -> typeBuilder.containing(DslElementModel.builder().withModel(model).withDsl(modelDsl).withValue((String)defaultValue.get()).isExplicitInDsl(false).build()));
            }
        };
    }

    private DslElementModel createMapElement(ObjectType objectType, DslElementSyntax modelDsl, ComponentConfiguration configuration) {
        DslElementModel.Builder<ObjectType> mapBuilder = DslElementModel.builder().withModel(objectType).withDsl(modelDsl).withConfig(configuration);
        if (configuration != null && !configuration.getNestedComponents().isEmpty()) {
            this.populateMapEntries(objectType, modelDsl, mapBuilder, configuration);
        }
        return mapBuilder.build();
    }

    private void populateMapEntries(ObjectType objectType, DslElementSyntax modelDsl, DslElementModel.Builder mapBuilder, ComponentConfiguration mapConfig) {
        mapConfig.getNestedComponents().forEach(entryConfig -> {
            MetadataType entryType = objectType.getOpenRestriction().get();
            modelDsl.getGeneric(entryType).ifPresent(entryDsl -> {
                DslElementModel.Builder<MetadataType> entry = DslElementModel.builder().withModel(entryType).withConfig((ComponentConfiguration)entryConfig).withDsl((DslElementSyntax)entryDsl);
                entry.containing(DslElementModel.builder().withModel(this.typeLoader.load((Type)((Object)String.class))).withValue(entryConfig.getParameters().get("key")).withDsl(entryDsl.getAttribute("key").get()).build());
                String value = entryConfig.getParameters().get("value");
                if (StringUtils.isBlank((CharSequence)value)) {
                    this.getComponentChildVisitor(entry, (ComponentConfiguration)entryConfig, entryType, "value", entryDsl.getAttribute("value").get(), Optional.empty(), (Deque<String>)new ArrayDeque<String>());
                } else {
                    entry.containing(DslElementModel.builder().withModel(this.typeLoader.load((Type)((Object)String.class))).withValue(value).withDsl(entryDsl.getAttribute("value").get()).build());
                }
                mapBuilder.containing(entry.build());
            });
        });
    }

    private DslElementModel<ConnectionProviderModel> createConnectionProviderModel(ConnectionProviderModel providerModel, DslElementSyntax providerDsl, ComponentConfiguration providerConfig) {
        return this.createElementModel(providerModel, providerDsl, providerConfig).build();
    }

    private DslElementModel.Builder<ConfigurationModel> addConnectionProvider(ConfigurationModel model, DslSyntaxResolver dsl, DslElementModel.Builder<ConfigurationModel> element, ComponentConfiguration configuration) {
        Stream.concat(model.getConnectionProviders().stream(), this.currentExtension.getConnectionProviders().stream()).map(provider -> {
            DslElementSyntax providerDsl = dsl.resolve((NamedObject)provider);
            ComponentIdentifier identifier = this.getIdentifier(providerDsl).orElse(null);
            return configuration.getNestedComponents().stream().filter(c -> c.getIdentifier().equals(identifier)).findFirst().map(providerConfig -> element.containing(this.createConnectionProviderModel((ConnectionProviderModel)provider, providerDsl, (ComponentConfiguration)providerConfig)).build()).orElse(null);
        }).filter(Objects::nonNull).findFirst();
        return element;
    }

    private <T extends ParameterizedModel> DslElementModel.Builder<T> createElementModel(T model, DslElementSyntax elementDsl, ComponentConfiguration configuration) {
        DslElementModel.Builder<T> builder = DslElementModel.builder();
        builder.withModel(model).withDsl(elementDsl).withConfig(configuration);
        this.enrichElementModel(model, elementDsl, configuration, builder);
        return builder;
    }

    private <T extends ParameterizedModel> void enrichElementModel(T model, DslElementSyntax elementDsl, ComponentConfiguration configuration, DslElementModel.Builder<T> builder) {
        this.populateParameterizedElements(model, elementDsl, builder, configuration);
        if (model instanceof ComposableModel) {
            this.populateComposableElements((ComposableModel)((Object)model), elementDsl, builder, configuration);
        }
        if (model instanceof SourceModel) {
            ((SourceModel)model).getSuccessCallback().ifPresent(cb -> this.populateParameterizedElements((ParameterizedModel)cb, elementDsl, builder, configuration));
            ((SourceModel)model).getErrorCallback().ifPresent(cb -> this.populateParameterizedElements((ParameterizedModel)cb, elementDsl, builder, configuration));
        }
    }

    private void populateParameterizedElements(ParameterizedModel model, DslElementSyntax elementDsl, DslElementModel.Builder builder, ComponentConfiguration configuration) {
        Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents = this.getNestedComponents(configuration);
        Map<String, String> parameters = configuration.getParameters();
        List inlineGroupedParameters = model.getParameterGroupModels().stream().filter(ParameterGroupModel::isShowInDsl).peek(group -> this.addInlineGroup(elementDsl, innerComponents, parameters, builder, (ParameterGroupModel)group)).flatMap(g -> g.getParameterModels().stream()).collect(Collectors.toList());
        model.getAllParameterModels().stream().filter(p -> !inlineGroupedParameters.contains(p)).forEach(p -> this.addElementParameter(innerComponents, parameters, elementDsl, builder, (ParameterModel)p));
    }

    private void populateComposableElements(ComposableModel model, DslElementSyntax elementDsl, DslElementModel.Builder builder, ComponentConfiguration configuration) {
        configuration.getNestedComponents().forEach(nestedComponentConfig -> {
            DslElementModel nestedElement = this.createIdentifiedElement((ComponentConfiguration)nestedComponentConfig);
            if (nestedElement != null) {
                builder.containing(nestedElement);
            } else {
                model.getNestedComponents().stream().filter(nestedModel -> nestedModel instanceof NestedRouteModel).filter(nestedModel -> elementDsl.getContainedElement(nestedModel.getName()).map(nestedDsl -> this.getIdentifier((DslElementSyntax)nestedDsl).map(id -> nestedComponentConfig.getIdentifier().equals(id)).orElse(false)).orElse(false)).findFirst().ifPresent(nestedModel -> {
                    DslElementSyntax routeDsl = elementDsl.getContainedElement(nestedModel.getName()).get();
                    DslElementModel.Builder<NestableElementModel> routeBuilder = DslElementModel.builder().withModel((NestableElementModel)nestedModel).withDsl(routeDsl).withConfig((ComponentConfiguration)nestedComponentConfig).isExplicitInDsl(true);
                    this.populateParameterizedElements((ParameterizedModel)nestedModel, routeDsl, routeBuilder, (ComponentConfiguration)nestedComponentConfig);
                    nestedComponentConfig.getNestedComponents().forEach(routeElement -> {
                        DslElementModel nestableElementModel = this.createIdentifiedElement((ComponentConfiguration)routeElement);
                        if (nestableElementModel != null) {
                            routeBuilder.containing(nestableElementModel);
                        }
                    });
                    builder.containing(routeBuilder.build());
                });
            }
        });
    }

    private void addInlineGroup(DslElementSyntax elementDsl, Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents, Map<String, String> parameters, DslElementModel.Builder parent, ParameterGroupModel group) {
        elementDsl.getChild(group.getName()).ifPresent(groupDsl -> {
            Optional<ComponentIdentifier> identifier = this.getIdentifier((DslElementSyntax)groupDsl);
            if (!identifier.isPresent()) {
                return;
            }
            ComponentConfiguration groupComponent = this.getSingleComponentConfiguration(innerComponents, identifier);
            if (groupComponent != null) {
                DslElementModel.Builder<ParameterGroupModel> groupElementBuilder = DslElementModel.builder().withModel(group).withDsl((DslElementSyntax)groupDsl).withConfig(groupComponent);
                Multimap<ComponentIdentifier, ComponentConfiguration> groupInnerComponents = this.getNestedComponents(groupComponent);
                group.getParameterModels().forEach(p -> this.addElementParameter(groupInnerComponents, parameters, (DslElementSyntax)groupDsl, groupElementBuilder, (ParameterModel)p));
                parent.containing(groupElementBuilder.build());
            } else if (this.shoulBuildDefaultGroup(group)) {
                this.builDefaultInlineGroupElement(parent, group, (DslElementSyntax)groupDsl, identifier.get());
            }
        });
    }

    private ComponentConfiguration getSingleComponentConfiguration(Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents, Optional<ComponentIdentifier> identifier) {
        return identifier.filter(arg_0 -> innerComponents.containsKey(arg_0)).map(arg_0 -> innerComponents.get(arg_0)).map(collection -> (ComponentConfiguration)collection.iterator().next()).orElse(null);
    }

    private void builDefaultInlineGroupElement(DslElementModel.Builder parent, ParameterGroupModel group, DslElementSyntax groupDsl, ComponentIdentifier identifier) {
        InternalComponentConfiguration.Builder groupConfigBuilder = InternalComponentConfiguration.builder().withIdentifier(identifier);
        DslElementModel.Builder<ParameterGroupModel> groupElementBuilder = DslElementModel.builder().withModel(group).isExplicitInDsl(false).withDsl(groupDsl);
        group.getParameterModels().forEach(paramModel -> groupDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> ExtensionModelUtils.getDefaultValue(paramModel).ifPresent(defaultValue -> {
            DslElementModel.Builder<ParameterModel> paramElementBuilder = DslElementModel.builder().withModel((ParameterModel)paramModel).withDsl((DslElementSyntax)paramDsl).isExplicitInDsl(false).withValue((String)defaultValue);
            if (ExtensionModelUtils.isContent(paramModel) || ExtensionModelUtils.isText(paramModel)) {
                this.getIdentifier((DslElementSyntax)paramDsl).ifPresent(tagId -> groupConfigBuilder.withNestedComponent(InternalComponentConfiguration.builder().withIdentifier((ComponentIdentifier)tagId).withValue((String)defaultValue).build()));
            } else {
                groupConfigBuilder.withParameter(paramDsl.getAttributeName(), (String)defaultValue);
            }
            groupElementBuilder.containing(paramElementBuilder.build());
        })));
        groupElementBuilder.withConfig(groupConfigBuilder.build());
        parent.containing(groupElementBuilder.build());
    }

    private boolean shoulBuildDefaultGroup(ParameterGroupModel group) {
        return !ExtensionModelUtils.isRequired(group) && group.getParameterModels().stream().anyMatch(p -> ExtensionModelUtils.getDefaultValue(p).isPresent());
    }

    private void addElementParameter(Multimap<ComponentIdentifier, ComponentConfiguration> innerComponents, Map<String, String> parameters, DslElementSyntax groupDsl, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel paramModel) {
        groupDsl.getContainedElement(paramModel.getName()).ifPresent(paramDsl -> {
            if (ExtensionModelUtils.isInfrastructure(paramModel)) {
                this.handleInfrastructure(paramModel, (DslElementSyntax)paramDsl, innerComponents, parameters, groupElementBuilder);
                return;
            }
            ComponentConfiguration paramComponent = this.getSingleComponentConfiguration(innerComponents, this.getIdentifier((DslElementSyntax)paramDsl));
            if (paramDsl.isWrapped()) {
                this.resolveWrappedElement(groupElementBuilder, paramModel, (DslElementSyntax)paramDsl, paramComponent);
                return;
            }
            String value = paramDsl.supportsAttributeDeclaration() ? (String)parameters.get(paramDsl.getAttributeName()) : null;
            Optional<String> defaultValue = ExtensionModelUtils.getDefaultValue(paramModel);
            if (paramComponent != null || !StringUtils.isBlank((CharSequence)value) || defaultValue.isPresent()) {
                DslElementModel.Builder<ParameterModel> paramElementBuilder = DslElementModel.builder().withModel(paramModel).withDsl((DslElementSyntax)paramDsl);
                if (paramComponent != null && !ExtensionModelUtils.isContent(paramModel)) {
                    paramElementBuilder.withConfig(paramComponent);
                    paramModel.getType().accept(new MetadataTypeVisitor((DslElementSyntax)paramDsl, paramComponent, paramElementBuilder, defaultValue){
                        final /* synthetic */ DslElementSyntax val$paramDsl;
                        final /* synthetic */ ComponentConfiguration val$paramComponent;
                        final /* synthetic */ DslElementModel.Builder val$paramElementBuilder;
                        final /* synthetic */ Optional val$defaultValue;
                        {
                            this.val$paramDsl = dslElementSyntax;
                            this.val$paramComponent = componentConfiguration;
                            this.val$paramElementBuilder = builder;
                            this.val$defaultValue = optional;
                        }

                        @Override
                        public void visitArrayType(ArrayType arrayType) {
                            MetadataType itemType = arrayType.getType();
                            this.val$paramDsl.getGeneric(itemType).ifPresent(itemdsl -> {
                                ComponentIdentifier itemIdentifier = (ComponentIdentifier)ConfigurationBasedElementModelFactory.this.getIdentifier(itemdsl).get();
                                this.val$paramComponent.getNestedComponents().forEach(c -> {
                                    if (c.getIdentifier().equals(itemIdentifier)) {
                                        itemType.accept(ConfigurationBasedElementModelFactory.this.getComponentChildVisitor(this.val$paramElementBuilder, c, itemType, "value", itemdsl, this.val$defaultValue, new ArrayDeque()));
                                    }
                                });
                            });
                        }

                        @Override
                        public void visitObject(ObjectType objectType) {
                            if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                                ConfigurationBasedElementModelFactory.this.populateMapEntries(objectType, this.val$paramDsl, this.val$paramElementBuilder, this.val$paramComponent);
                                return;
                            }
                            ConfigurationBasedElementModelFactory.this.populateObjectFields(objectType, this.val$paramComponent, this.val$paramDsl, this.val$paramElementBuilder, new ArrayDeque());
                        }
                    });
                } else {
                    if (StringUtils.isBlank((CharSequence)value)) {
                        if (paramComponent != null && paramComponent.getValue().isPresent() && !StringUtils.isBlank((CharSequence)paramComponent.getValue().get())) {
                            value = paramComponent.getValue().get().trim();
                        } else if (defaultValue.isPresent()) {
                            value = defaultValue.get();
                            paramElementBuilder.isExplicitInDsl(false);
                        }
                    }
                    paramElementBuilder.withValue(value);
                }
                groupElementBuilder.containing(paramElementBuilder.build());
            }
        });
    }

    private void resolveWrappedElement(DslElementModel.Builder<ParameterGroupModel> groupElementBuilder, ParameterModel p, DslElementSyntax pDsl, ComponentConfiguration paramComponent) {
        if (paramComponent != null) {
            DslElementModel.Builder<ParameterModel> paramElement = DslElementModel.builder().withModel(p).withDsl(pDsl).withConfig(paramComponent);
            if (paramComponent.getNestedComponents().size() > 0) {
                ExtensionModel wrapperExtension = this.currentExtension;
                DslSyntaxResolver wrapperDsl = this.dsl;
                ComponentConfiguration wrappedComponent = paramComponent.getNestedComponents().get(0);
                this.create(wrappedComponent).ifPresent(paramElement::containing);
                this.currentExtension = wrapperExtension;
                this.dsl = wrapperDsl;
            }
            groupElementBuilder.containing(paramElement.build());
        }
    }

    private Optional<ComponentIdentifier> getIdentifier(DslElementSyntax dsl) {
        if (StringUtils.isNotBlank((CharSequence)dsl.getElementName()) && StringUtils.isNotBlank((CharSequence)dsl.getPrefix())) {
            return Optional.of(ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build());
        }
        return Optional.empty();
    }

    private void handleInfrastructure(ParameterModel paramModel, DslElementSyntax paramDsl, Multimap<ComponentIdentifier, ComponentConfiguration> nested, Map<String, String> parameters, DslElementModel.Builder<ParameterGroupModel> groupElementBuilder) {
        switch (paramModel.getName()) {
            case "reconnection": {
                ComponentConfiguration reconnection = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.RECONNECTION_CONFIG_PARAMETER_IDENTIFIER));
                if (reconnection != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, reconnection));
                }
                return;
            }
            case "reconnectionStrategy": {
                ComponentConfiguration config;
                ComponentConfiguration componentConfiguration = config = nested.containsKey((Object)ApplicationModel.RECONNECT_IDENTIFIER) ? this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.RECONNECT_IDENTIFIER)) : this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.RECONNECT_FOREVER_IDENTIFIER));
                if (config != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, config));
                }
                return;
            }
            case "redeliveryPolicy": {
                ComponentConfiguration redelivery = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.REDELIVERY_POLICY_IDENTIFIER));
                if (redelivery != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, redelivery));
                }
                return;
            }
            case "expirationPolicy": {
                ComponentConfiguration expiration = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.EXPIRATION_POLICY_IDENTIFIER));
                if (expiration != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, expiration));
                }
                return;
            }
            case "poolingProfile": {
                ComponentConfiguration pooling = this.getSingleComponentConfiguration(nested, this.getIdentifier(paramDsl));
                if (pooling != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, pooling));
                }
                return;
            }
            case "streamingStrategy": {
                HashSet streaming = Sets.newHashSet((Object[])new ComponentIdentifier[]{ApplicationModel.NON_REPEATABLE_STREAM_IDENTIFIER, ApplicationModel.REPEATABLE_IN_MEMORY_STREAM_IDENTIFIER, ApplicationModel.REPEATABLE_FILE_STORE_STREAM_IDENTIFIER, ApplicationModel.REPEATABLE_IN_MEMORY_ITERABLE_IDENTIFIER, ApplicationModel.REPEATABLE_FILE_STORE_ITERABLE_IDENTIFIER, ApplicationModel.NON_REPEATABLE_ITERABLE_IDENTIFIER});
                streaming.stream().filter(arg_0 -> nested.containsKey(arg_0)).findFirst().ifPresent(s -> groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, this.getSingleComponentConfiguration(nested, Optional.of(s)))));
                return;
            }
            case "tlsContext": {
                ComponentConfiguration tls = this.getSingleComponentConfiguration(nested, this.getIdentifier(paramDsl));
                if (tls != null) {
                    groupElementBuilder.containing(this.newElementModel(paramModel, paramDsl, tls));
                } else if (!StringUtils.isBlank((CharSequence)parameters.get("tlsContext"))) {
                    groupElementBuilder.containing(DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).withValue(parameters.get("tlsContext")).build());
                }
                return;
            }
            case "schedulingStrategy": {
                ComponentConfiguration schedulingStrategyWrapper = this.getSingleComponentConfiguration(nested, Optional.of(ApplicationModel.SCHEDULING_STRATEGY_IDENTIFIER));
                if (schedulingStrategyWrapper != null) {
                    DslElementModel.Builder<ParameterModel> wrapper = DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).withConfig(schedulingStrategyWrapper);
                    Iterator<ComponentConfiguration> nestedIt = schedulingStrategyWrapper.getNestedComponents().iterator();
                    if (nestedIt.hasNext()) {
                        ComponentConfiguration strategy = nestedIt.next();
                        MetadataType type = ApplicationModel.CRON_STRATEGY_IDENTIFIER.equals(strategy.getIdentifier()) ? this.typeLoader.load((Type)((Object)CronScheduler.class)) : this.typeLoader.load((Type)((Object)FixedFrequencyScheduler.class));
                        this.dsl.resolve(type).ifPresent(typeDsl -> wrapper.containing(DslElementModel.builder().withModel(type).withDsl((DslElementSyntax)typeDsl).withConfig(strategy).build()));
                    }
                    groupElementBuilder.containing(wrapper.build());
                }
                return;
            }
        }
    }

    private DslElementModel newElementModel(ParameterModel paramModel, DslElementSyntax paramDsl, ComponentConfiguration configuration) {
        return DslElementModel.builder().withModel(paramModel).withDsl(paramDsl).withConfig(configuration).build();
    }

    private static /* synthetic */ void lambda$getNestedComponents$8(Multimap result, ComponentConfiguration componentConfiguration) {
        result.put((Object)componentConfiguration.getIdentifier(), (Object)componentConfiguration);
    }
}

