/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;

public class ErrorHandlerOnErrorTypeExists
extends AbstractErrorTypesValidation {
    @Override
    public String getName() {
        return "Error Type references exist";
    }

    @Override
    public String getDescription() {
        return "Referenced error types do exist in the context of the artifact.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.WARN;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(comp -> (comp.getIdentifier().equals(ON_ERROR_IDENTIFIER) || comp.getIdentifier().equals(ON_ERROR_PROPAGATE_IDENTIFIER) || comp.getIdentifier().equals(ON_ERROR_CONTINUE_IDENTIFIER)) && comp.getParameter("General", "type") != null && comp.getParameter("General", "type").getResolvedRawValue() != null);
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst onErrorModel, ArtifactAst artifact) {
        ComponentParameterAst errorTypeParam = onErrorModel.getParameter("General", "type");
        for (String type : errorTypeParam.getResolvedRawValue().split(",")) {
            ComponentIdentifier parsedErrorType = ErrorHandlerOnErrorTypeExists.parserErrorType(type.trim());
            if ("*".equals(parsedErrorType.getNamespace()) || "*".equals(parsedErrorType.getName())) {
                return Optional.empty();
            }
            Optional<ErrorType> errorType = artifact.getErrorTypeRepository().lookupErrorType(parsedErrorType);
            if (errorType.isPresent()) continue;
            return Optional.of(ValidationResultItem.create(onErrorModel, errorTypeParam, (Validation)this, String.format("Could not find error '%s'", type.trim())));
        }
        return Optional.empty();
    }
}

