/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.util.Preconditions;

public class ExceptionMapping
implements Comparable<ExceptionMapping> {
    private Class<? extends Throwable> exceptionType;
    private ErrorType errorType;

    public ExceptionMapping(Class<? extends Throwable> exceptionType, ErrorType errorType) {
        Preconditions.checkState(exceptionType != null, "exceptionType type cannot be null");
        Preconditions.checkState(errorType != null, "error type cannot be null");
        this.exceptionType = exceptionType;
        this.errorType = errorType;
    }

    public boolean matches(Class<? extends Throwable> exception) {
        return this.exceptionType.isAssignableFrom(exception);
    }

    public ErrorType getErrorType() {
        return this.errorType;
    }

    @Override
    public int compareTo(ExceptionMapping exceptionMapping) {
        if (this.exceptionType.equals(exceptionMapping.exceptionType)) {
            return 0;
        }
        if (this.exceptionType.isAssignableFrom(exceptionMapping.exceptionType)) {
            return 1;
        }
        if (exceptionMapping.exceptionType.isAssignableFrom(this.exceptionType)) {
            return -1;
        }
        return 1;
    }
}

