/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling.producer;

import java.util.function.Function;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingProducerScope;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.context.ExtensionProfilingEventContext;
import org.mule.runtime.core.internal.profiling.DefaultProfilingService;
import org.mule.runtime.core.internal.profiling.ResettableProfilingDataProducer;
import org.mule.runtime.core.internal.profiling.consumer.annotations.RuntimeInternalProfilingDataConsumer;
import org.mule.runtime.feature.internal.config.profiling.ProfilingDataProducerStatus;
import org.mule.runtime.feature.internal.config.profiling.ProfilingFeatureFlaggingService;

@RuntimeInternalProfilingDataConsumer
public class ExtensionProfilingDataProducer
implements ResettableProfilingDataProducer<ExtensionProfilingEventContext, Object> {
    private final DefaultProfilingService defaultProfilingService;
    private final ProfilingEventType<ExtensionProfilingEventContext> profilingEventType;
    private ProfilingDataProducerStatus profilingProducerStatus;

    public ExtensionProfilingDataProducer(DefaultProfilingService defaultProfilingService, ProfilingEventType<ExtensionProfilingEventContext> profilingEventType, ProfilingProducerScope profilingProducerContext, ProfilingFeatureFlaggingService featureFlaggingService) {
        this.defaultProfilingService = defaultProfilingService;
        this.profilingEventType = profilingEventType;
        this.profilingProducerStatus = featureFlaggingService.getProfilingDataProducerStatus(profilingEventType, profilingProducerContext);
    }

    @Override
    public void triggerProfilingEvent(ExtensionProfilingEventContext profilingEventContext) {
        if (this.profilingProducerStatus == null) {
            this.reset();
        }
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent(profilingEventContext, this.profilingEventType);
        }
    }

    @Override
    public void triggerProfilingEvent(Object sourceData, Function<Object, ExtensionProfilingEventContext> transformation) {
        if (this.profilingProducerStatus.isEnabled()) {
            this.defaultProfilingService.notifyEvent((ProfilingEventContext)transformation.apply(sourceData), this.profilingEventType);
        }
    }

    @Override
    public void reset() {
        this.profilingProducerStatus.reset();
    }
}

