/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.dsl.syntax;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.text.WordUtils;
import org.mule.metadata.api.model.AnyType;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.model.UnionType;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.metadata.java.api.annotation.ClassInformationAnnotation;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ParameterDslConfiguration;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.type.TypeCatalog;
import org.mule.runtime.extension.api.declaration.type.annotation.ExpressionSupportAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ExtensibleTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.LayoutTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.ParameterDslAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.TypeDslAnnotation;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.extension.api.util.NameUtils;
import org.mule.runtime.extension.api.util.XmlModelUtils;

public final class DslSyntaxUtils {
    private static final String CONNECTION_PROVIDER_SUFFIX = "connection";
    private static final String CONFIGURATION_SUFFIX = "config";
    private static final Pattern SANITIZE_PATTERN = Pattern.compile("\\s+");

    private DslSyntaxUtils() {
    }

    static String getSanitizedElementName(NamedObject component) {
        String name = SANITIZE_PATTERN.matcher(NameUtils.hyphenize(NameUtils.sanitizeName(WordUtils.capitalize((String)component.getName())))).replaceAll("");
        if (component instanceof ConfigurationModel) {
            return DslSyntaxUtils.appendSuffix(name, CONFIGURATION_SUFFIX);
        }
        if (component instanceof ConnectionProviderModel) {
            return DslSyntaxUtils.appendSuffix(name, CONNECTION_PROVIDER_SUFFIX);
        }
        return name;
    }

    private static String appendSuffix(String name, String suffix) {
        return !name.toLowerCase().endsWith(suffix) ? name.concat("-" + suffix) : name;
    }

    static boolean isValidBean(ObjectType objectType) {
        if (objectType.getAnnotation(ClassInformationAnnotation.class).isPresent()) {
            return DslSyntaxUtils.isInstantiable(objectType) && !objectType.getFields().isEmpty();
        }
        return objectType.getAnnotation(TypeDslAnnotation.class).map(dsl -> dsl.allowsInlineDefinition() || dsl.allowsTopLevelDefinition()).orElse(false);
    }

    static boolean isFlattened(ObjectFieldType field, MetadataType fieldValue) {
        return fieldValue instanceof ObjectType && field.getAnnotation(FlattenedTypeAnnotation.class).isPresent();
    }

    static Optional<String> getTypeKey(MetadataType type, String namespace, String namespaceUri) {
        return DslSyntaxUtils.getTypeId(type).map(typeId -> typeId + namespace + namespaceUri);
    }

    static Optional<String> getTypeId(MetadataType type) {
        return Optional.ofNullable(ExtensionMetadataTypeUtils.getId(type).orElse(!StringUtils.isEmpty((CharSequence)ExtensionMetadataTypeUtils.getAlias(type)) ? ExtensionMetadataTypeUtils.getAlias(type) : null));
    }

    static boolean isText(ParameterModel parameter) {
        return parameter.getLayoutModel().map(LayoutModel::isText).orElse(false);
    }

    static boolean isText(MetadataType type) {
        return type.getAnnotation(LayoutTypeAnnotation.class).map(layoutTypeAnnotation -> layoutTypeAnnotation.isText()).orElse(false);
    }

    static boolean isInstantiable(MetadataType metadataType) {
        Optional<ClassInformationAnnotation> classInformation = metadataType.getAnnotation(ClassInformationAnnotation.class);
        return classInformation.map(ClassInformationAnnotation::isInstantiable).orElse(false);
    }

    static boolean isExtensible(MetadataType metadataType) {
        return metadataType.getAnnotation(ExtensibleTypeAnnotation.class).isPresent();
    }

    static boolean supportAttributeDeclaration(MetadataType metadataType) {
        return metadataType.getAnnotation(ParameterDslAnnotation.class).map(fieldDsl -> metadataType.getAnnotation(ExpressionSupportAnnotation.class).map(ExpressionSupportAnnotation::getExpressionSupport).map(exprSupport -> !exprSupport.equals((Object)ExpressionSupport.NOT_SUPPORTED) || fieldDsl.allowsReferences()).orElse(true)).orElse(true);
    }

    static boolean supportTopLevelElement(MetadataType metadataType) {
        return DslSyntaxUtils.supportTopLevelElement(metadataType, metadataType.getAnnotation(ParameterDslAnnotation.class).map(ParameterDslAnnotation::allowsReferences).orElse(true));
    }

    static boolean supportTopLevelElement(MetadataType metadataType, ParameterDslConfiguration dslConfiguration) {
        return DslSyntaxUtils.supportTopLevelElement(metadataType, dslConfiguration.allowsReferences());
    }

    static boolean supportTopLevelElement(MetadataType metadataType, boolean allowsReferences) {
        if (!allowsReferences) {
            return false;
        }
        final AtomicBoolean supporstGlobalDeclaration = new AtomicBoolean(false);
        metadataType.accept(new MetadataTypeVisitor(){

            @Override
            public void visitObject(ObjectType objectType) {
                supporstGlobalDeclaration.set(XmlModelUtils.supportsTopLevelDeclaration(objectType) && (DslSyntaxUtils.isValidBean(objectType) || ExtensionMetadataTypeUtils.isInfrastructure(objectType)));
            }
        });
        return supporstGlobalDeclaration.get();
    }

    static boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport) {
        return DslSyntaxUtils.supportsInlineDeclaration(metadataType, expressionSupport, ParameterDslConfiguration.getDefaultInstance(), false);
    }

    static boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport, boolean isContent) {
        return DslSyntaxUtils.supportsInlineDeclaration(metadataType, expressionSupport, ParameterDslConfiguration.getDefaultInstance(), isContent);
    }

    public static boolean supportsInlineDeclaration(MetadataType metadataType, ExpressionSupport expressionSupport, ParameterDslConfiguration dslModel, boolean isContent) {
        final AtomicBoolean supportsChildDeclaration = new AtomicBoolean(false);
        if (isContent) {
            return true;
        }
        if (ExpressionSupport.REQUIRED == expressionSupport) {
            return false;
        }
        if (!dslModel.allowsInlineDefinition()) {
            return false;
        }
        metadataType.accept(new MetadataTypeVisitor(){

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                supportsChildDeclaration.set(true);
            }

            @Override
            public void visitAnyType(AnyType anyType) {
                supportsChildDeclaration.set(false);
            }

            @Override
            public void visitArrayType(ArrayType arrayType) {
                final 2 currentVisitor = this;
                arrayType.getType().accept(new MetadataTypeVisitor(){

                    @Override
                    public void visitObject(ObjectType objectType) {
                        if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                            supportsChildDeclaration.set(false);
                        } else {
                            objectType.accept(currentVisitor);
                        }
                    }

                    @Override
                    protected void defaultVisit(MetadataType metadataType) {
                        metadataType.accept(currentVisitor);
                    }
                });
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    supportsChildDeclaration.set(true);
                } else {
                    supportsChildDeclaration.set((DslSyntaxUtils.isValidBean(objectType) || ExtensionMetadataTypeUtils.isInfrastructure(objectType)) && ExtensionMetadataTypeUtils.allowsInlineDefinition(objectType));
                }
            }

            @Override
            public void visitUnion(UnionType unionType) {
                supportsChildDeclaration.set(false);
            }
        });
        return supportsChildDeclaration.get();
    }

    public static boolean typeRequiresWrapperElement(MetadataType metadataType, TypeCatalog typeCatalog) {
        return metadataType instanceof ObjectType && (DslSyntaxUtils.isExtensible(metadataType) || typeCatalog.containsBaseType((ObjectType)metadataType));
    }
}

