/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.domain;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import java.util.stream.Collectors;
import org.mule.runtime.api.lock.LockFactory;
import org.mule.runtime.api.service.ServiceRepository;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.DeployableArtifactDescriptor;
import org.mule.runtime.deployment.model.api.domain.Domain;
import org.mule.runtime.deployment.model.api.domain.DomainDescriptor;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPluginDescriptor;
import org.mule.runtime.deployment.model.internal.DefaultRegionPluginClassLoadersFactory;
import org.mule.runtime.deployment.model.internal.domain.DomainClassLoaderBuilder;
import org.mule.runtime.deployment.model.internal.plugin.PluginDependenciesResolver;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderRepository;
import org.mule.runtime.module.artifact.api.classloader.MuleDeployableArtifactClassLoader;
import org.mule.runtime.module.deployment.impl.internal.artifact.AbstractDeployableArtifactFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DefaultMuleDomain;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainClassLoaderBuilderFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainDescriptorFactory;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainManager;
import org.mule.runtime.module.deployment.impl.internal.domain.DomainWrapper;
import org.mule.runtime.module.deployment.impl.internal.domain.EmptyDomainDescriptor;
import org.mule.runtime.module.deployment.impl.internal.plugin.DefaultArtifactPlugin;
import org.mule.runtime.module.extension.internal.loader.ExtensionModelLoaderManager;
import org.mule.runtime.module.license.api.LicenseValidator;
import org.mule.runtime.module.reboot.api.MuleContainerBootstrapUtils;

public class DefaultDomainFactory
extends AbstractDeployableArtifactFactory<Domain> {
    private final DomainManager domainManager;
    private final DomainDescriptorFactory domainDescriptorFactory;
    private final ClassLoaderRepository classLoaderRepository;
    private final ServiceRepository serviceRepository;
    private final PluginDependenciesResolver pluginDependenciesResolver;
    private final DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory;
    private final ExtensionModelLoaderManager extensionModelLoaderManager;

    public DefaultDomainFactory(DomainDescriptorFactory domainDescriptorFactory, DomainManager domainManager, ClassLoaderRepository classLoaderRepository, ServiceRepository serviceRepository, PluginDependenciesResolver pluginDependenciesResolver, DomainClassLoaderBuilderFactory domainClassLoaderBuilderFactory, ExtensionModelLoaderManager extensionModelLoaderManager, LicenseValidator licenseValidator, LockFactory runtimeLockFactory) {
        super(licenseValidator, runtimeLockFactory);
        Preconditions.checkArgument(domainDescriptorFactory != null, "domainDescriptorFactory cannot be null");
        Preconditions.checkArgument(domainManager != null, "Domain manager cannot be null");
        Preconditions.checkArgument(serviceRepository != null, "Service repository cannot be null");
        Preconditions.checkArgument(pluginDependenciesResolver != null, "pluginDependenciesResolver cannot be null");
        Preconditions.checkArgument(domainClassLoaderBuilderFactory != null, "domainClassLoaderBuilderFactory cannot be null");
        Preconditions.checkArgument(extensionModelLoaderManager != null, "extensionModelLoaderManager cannot be null");
        this.classLoaderRepository = classLoaderRepository;
        this.domainDescriptorFactory = domainDescriptorFactory;
        this.domainManager = domainManager;
        this.serviceRepository = serviceRepository;
        this.pluginDependenciesResolver = pluginDependenciesResolver;
        this.domainClassLoaderBuilderFactory = domainClassLoaderBuilderFactory;
        this.extensionModelLoaderManager = extensionModelLoaderManager;
    }

    private DomainDescriptor findDomain(String domainName, File domainLocation, Optional<Properties> deploymentProperties) throws IOException {
        if ("default".equals(domainName)) {
            return new EmptyDomainDescriptor(new File(MuleContainerBootstrapUtils.getMuleDomainsDir(), "default"));
        }
        DomainDescriptor descriptor = (DomainDescriptor)this.domainDescriptorFactory.create(domainLocation, deploymentProperties);
        return descriptor;
    }

    private List<ArtifactPlugin> createArtifactPluginList(MuleDeployableArtifactClassLoader domainClassLoader, List<ArtifactPluginDescriptor> plugins) {
        return plugins.stream().map(artifactPluginDescriptor -> new DefaultArtifactPlugin(DefaultRegionPluginClassLoadersFactory.getArtifactPluginId(domainClassLoader.getArtifactId(), artifactPluginDescriptor.getName()), (ArtifactPluginDescriptor)artifactPluginDescriptor, domainClassLoader.getArtifactPluginClassLoaders().stream().filter(artifactClassLoader -> {
            String artifactPluginDescriptorName = "/plugin/" + artifactPluginDescriptor.getName();
            return artifactClassLoader.getArtifactId().endsWith(artifactPluginDescriptorName);
        }).findFirst().get())).collect(Collectors.toList());
    }

    @Override
    public File getArtifactDir() {
        return MuleContainerBootstrapUtils.getMuleDomainsDir();
    }

    public void dispose(DomainWrapper domain) {
        this.domainManager.removeDomain(domain);
    }

    public void start(DomainWrapper domainWrapper) {
        this.domainManager.addDomain(domainWrapper);
    }

    @Override
    protected Domain doCreateArtifact(File domainLocation, Optional<Properties> deploymentProperties) throws IOException {
        String domainName = domainLocation.getName();
        if (this.domainManager.contains(domainName)) {
            throw new IllegalArgumentException(String.format("Domain '%s'  already exists", domainName));
        }
        if (domainName.contains(" ")) {
            throw new IllegalArgumentException("Mule domain name may not contain spaces: " + domainName);
        }
        DomainDescriptor domainDescriptor = this.findDomain(domainName, domainLocation, deploymentProperties);
        List<ArtifactPluginDescriptor> resolvedArtifactPluginDescriptors = this.pluginDependenciesResolver.resolve(Collections.emptySet(), domainDescriptor.getPlugins().stream().collect(Collectors.toList()), true);
        DomainClassLoaderBuilder artifactClassLoaderBuilder = this.domainClassLoaderBuilderFactory.createArtifactClassLoaderBuilder();
        MuleDeployableArtifactClassLoader domainClassLoader = ((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)((DomainClassLoaderBuilder)artifactClassLoaderBuilder.addArtifactPluginDescriptors(resolvedArtifactPluginDescriptors.toArray(new ArtifactPluginDescriptor[resolvedArtifactPluginDescriptors.size()]))).setArtifactId(domainDescriptor.getName())).setArtifactDescriptor(domainDescriptor)).build();
        List<ArtifactPlugin> artifactPlugins = this.createArtifactPluginList(domainClassLoader, resolvedArtifactPluginDescriptors);
        DefaultMuleDomain defaultMuleDomain = new DefaultMuleDomain(domainDescriptor, domainClassLoader, this.classLoaderRepository, this.serviceRepository, artifactPlugins, this.extensionModelLoaderManager, this.getRuntimeLockFactory());
        DomainWrapper domainWrapper = new DomainWrapper(defaultMuleDomain, this);
        this.domainManager.addDomain(domainWrapper);
        return domainWrapper;
    }

    @Override
    public DeployableArtifactDescriptor createArtifactDescriptor(File artifactLocation, Optional<Properties> deploymentProperties) {
        return (DeployableArtifactDescriptor)this.domainDescriptorFactory.create(artifactLocation, deploymentProperties);
    }
}

