/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.execution;

import java.lang.reflect.Method;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.internal.event.NullEventFactory;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutor;
import org.mule.runtime.extension.api.runtime.operation.CompletableComponentExecutorFactory;
import org.mule.runtime.module.extension.internal.runtime.execution.CompletableMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.execution.NonBlockingCompletableMethodOperationExecutor;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.util.MuleExtensionUtils;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public final class CompletableOperationExecutorFactory<T, M extends ComponentModel>
implements CompletableComponentExecutorFactory<M> {
    private final Class<T> implementationClass;
    private final Method operationMethod;

    public CompletableOperationExecutorFactory(Class<T> implementationClass, Method operationMethod) {
        Preconditions.checkArgument(implementationClass != null, "implementationClass cannot be null");
        Preconditions.checkArgument(operationMethod != null, "operationMethod cannot be null");
        this.implementationClass = implementationClass;
        this.operationMethod = operationMethod;
    }

    @Override
    public CompletableComponentExecutor<M> createExecutor(M operationModel, Map<String, Object> parameters) {
        T delegate;
        DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder(this.implementationClass, new ReflectionCache());
        parameters.forEach((k, v) -> objectBuilder.addPropertyResolver((String)k, (ValueResolver<Object>)new StaticValueResolver<Object>(v)));
        CoreEvent initialiserEvent = null;
        try {
            initialiserEvent = NullEventFactory.getNullEvent();
            delegate = objectBuilder.build(ValueResolvingContext.builder(initialiserEvent).build());
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Could not create instance of operation class " + this.implementationClass.getName()), (Throwable)e);
        }
        finally {
            if (initialiserEvent != null) {
                ((BaseEventContext)initialiserEvent.getContext()).success();
            }
        }
        if (MuleExtensionUtils.isNonBlocking(operationModel)) {
            return new NonBlockingCompletableMethodOperationExecutor<M>(operationModel, this.operationMethod, delegate);
        }
        return new CompletableMethodOperationExecutor<M>(operationModel, this.operationMethod, delegate);
    }
}

