/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.oauth.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.LifecycleException;
import org.mule.runtime.oauth.api.ClientCredentialsOAuthDancer;
import org.mule.runtime.oauth.api.exception.RequestAuthenticationException;
import org.mule.runtime.oauth.api.exception.TokenNotFoundException;
import org.mule.runtime.oauth.api.exception.TokenUrlResponseException;
import org.mule.runtime.oauth.api.listener.ClientCredentialsListener;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContext;
import org.mule.runtime.oauth.api.state.ResourceOwnerOAuthContextWithRefreshState;
import org.mule.runtime.oauth.internal.AbstractOAuthDancer;
import org.mule.runtime.oauth.internal.config.DefaultClientCredentialsOAuthDancerConfig;
import org.mule.runtime.oauth.internal.util.ClassLoaderUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientCredentialsOAuthDancer
extends AbstractOAuthDancer<DefaultClientCredentialsOAuthDancerConfig>
implements ClientCredentialsOAuthDancer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultClientCredentialsOAuthDancer.class);
    private boolean accessTokenRefreshedOnStart = false;

    public DefaultClientCredentialsOAuthDancer(DefaultClientCredentialsOAuthDancerConfig config) {
        super(config);
    }

    @Override
    public void start() throws MuleException {
        super.start();
        try {
            this.refreshToken().get();
            this.accessTokenRefreshedOnStart = true;
        }
        catch (ExecutionException e) {
            if (!(e.getCause() instanceof TokenUrlResponseException) && !(e.getCause() instanceof TokenNotFoundException)) {
                super.stop();
                throw new LifecycleException(e.getCause(), (Object)this);
            }
        }
        catch (InterruptedException e) {
            super.stop();
            Thread.currentThread().interrupt();
            throw new LifecycleException(e, (Object)this);
        }
    }

    @Override
    public CompletableFuture<String> accessToken() throws RequestAuthenticationException {
        if (!this.accessTokenRefreshedOnStart) {
            this.accessTokenRefreshedOnStart = true;
            return this.refreshToken().thenApply(v -> this.getContext().getAccessToken());
        }
        String accessToken = this.getContext().getAccessToken();
        if (accessToken == null) {
            LOGGER.info("Previously stored token has been invalidated. Refreshing...");
            return this.doRefreshTokenRequest(false).thenApply(v -> this.getContext().getAccessToken());
        }
        return CompletableFuture.completedFuture(accessToken);
    }

    @Override
    public CompletableFuture<Void> refreshToken() {
        return this.doRefreshTokenRequest(true);
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners) {
        return this.doRefreshToken(() -> this.getContext(), ctx -> this.doRefreshTokenRequest(notifyListeners, (ResourceOwnerOAuthContextWithRefreshState)ctx));
    }

    private CompletableFuture<Void> doRefreshTokenRequest(boolean notifyListeners, ResourceOwnerOAuthContextWithRefreshState defaultUserState) {
        HashMap<String, String> formData = new HashMap<String, String>();
        formData.put("grant_type", "client_credentials");
        if (((DefaultClientCredentialsOAuthDancerConfig)this.config).getScopes() != null) {
            formData.put("scope", ((DefaultClientCredentialsOAuthDancerConfig)this.config).getScopes());
        }
        String authorization = this.handleClientCredentials(formData);
        return ((CompletableFuture)this.invokeTokenUrl(((DefaultClientCredentialsOAuthDancerConfig)this.config).getTokenUrl(), formData, ((DefaultClientCredentialsOAuthDancerConfig)this.config).getCustomParameters(), ((DefaultClientCredentialsOAuthDancerConfig)this.config).getCustomHeaders(), authorization, false, ((DefaultClientCredentialsOAuthDancerConfig)this.config).getEncoding()).thenAccept(tokenResponse -> {
            Thread thread = Thread.currentThread();
            ClassLoader currentClassLoader = thread.getContextClassLoader();
            ClassLoader contextClassLoader = DefaultClientCredentialsOAuthDancer.class.getClassLoader();
            ClassLoaderUtils.setContextClassLoader(thread, currentClassLoader, contextClassLoader);
            try {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Retrieved access token, refresh token and expires from token url are: %s, %s, %s", new Object[]{tokenResponse.getAccessToken(), tokenResponse.getRefreshToken(), tokenResponse.getExpiresIn()});
                }
                defaultUserState.setAccessToken(tokenResponse.getAccessToken());
                defaultUserState.setExpiresIn(tokenResponse.getExpiresIn());
                for (Map.Entry<String, Object> customResponseParameterEntry : tokenResponse.getCustomResponseParameters().entrySet()) {
                    defaultUserState.getTokenResponseParameters().put(customResponseParameterEntry.getKey(), customResponseParameterEntry.getValue());
                }
                this.updateOAuthContextAfterTokenResponse(defaultUserState);
                if (notifyListeners) {
                    this.forEachListener(l -> l.onTokenRefreshed(defaultUserState));
                }
            }
            finally {
                ClassLoaderUtils.setContextClassLoader(thread, contextClassLoader, currentClassLoader);
            }
        })).exceptionally(this.tokenUrlExceptionHandler(defaultUserState));
    }

    @Override
    public void addListener(ClientCredentialsListener listener) {
        this.doAddListener(listener);
    }

    @Override
    public void removeListener(ClientCredentialsListener listener) {
        this.doRemoveListener(listener);
    }

    @Override
    public void invalidateContext() {
        this.invalidateContext("default");
    }

    @Override
    public ResourceOwnerOAuthContext getContext() {
        return this.getContextForResourceOwner("default");
    }

    private void forEachListener(Consumer<ClientCredentialsListener> action) {
        this.onEachListener(listener -> action.accept((ClientCredentialsListener)listener));
    }
}

