/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.exception;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Lifecycle;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.api.notification.NotificationDispatcher;
import org.mule.runtime.core.api.context.MuleContextAware;
import org.mule.runtime.core.api.error.Errors;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.exception.SingleErrorTypeMatcher;
import org.mule.runtime.core.api.execution.ExceptionContextProvider;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.core.api.management.stats.FlowConstructStatistics;
import org.mule.runtime.core.api.processor.AbstractMuleObjectOwner;
import org.mule.runtime.core.internal.component.ComponentAnnotations;
import org.mule.runtime.core.internal.exception.ExceptionRouter;
import org.mule.runtime.core.internal.exception.OnCriticalErrorHandler;
import org.mule.runtime.core.internal.exception.OnErrorPropagateHandler;
import org.mule.runtime.core.internal.util.MessagingExceptionResolver;
import org.mule.runtime.core.privileged.exception.AbstractExceptionListener;
import org.mule.runtime.core.privileged.exception.ErrorTypeLocator;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.exception.MessagingExceptionHandlerAcceptor;
import org.mule.runtime.core.privileged.exception.TemplateOnErrorHandler;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

public class ErrorHandler
extends AbstractMuleObjectOwner<MessagingExceptionHandlerAcceptor>
implements MessagingExceptionHandlerAcceptor,
MuleContextAware,
Lifecycle {
    private static final String MUST_ACCEPT_ANY_EVENT_MESSAGE = "Default error handler must accept any event.";
    private List<MessagingExceptionHandlerAcceptor> exceptionListeners;
    private ErrorType anyErrorType;
    protected String name;
    @Inject
    private NotificationDispatcher notificationDispatcher;
    @Inject
    private ErrorTypeRepository errorTypeRepository;
    @Inject
    private ErrorTypeLocator errorTypeLocator;
    @Inject
    private Collection<ExceptionContextProvider> exceptionContextProviders;
    @Inject
    private FeatureFlaggingService featureFlaggingService;
    private final MessagingExceptionResolver messagingExceptionResolver = new MessagingExceptionResolver(this);

    @Override
    public void initialise() throws InitialisationException {
        super.initialise();
        this.anyErrorType = this.errorTypeRepository.getAnyErrorType();
        this.addCriticalErrorHandler();
        this.addDefaultErrorHandlerIfRequired();
        this.validateConfiguredExceptionStrategies();
    }

    @Override
    public CoreEvent handleException(Exception exception, CoreEvent event) {
        if (!(exception instanceof MessagingException)) {
            exception = new MessagingException(event, (Throwable)exception);
        }
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!exceptionListener.accept(event)) continue;
            return exceptionListener.handleException(exception, event);
        }
        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MUST_ACCEPT_ANY_EVENT_MESSAGE));
    }

    @Override
    public Consumer<Exception> router(Function<Publisher<CoreEvent>, Publisher<CoreEvent>> publisherPostProcessor, Consumer<CoreEvent> continueCallback, final Consumer<Throwable> propagateCallback) {
        final HashMap<MessagingExceptionHandlerAcceptor, Consumer<Exception>> routers = new HashMap<MessagingExceptionHandlerAcceptor, Consumer<Exception>>();
        for (MessagingExceptionHandlerAcceptor errorListener : this.exceptionListeners) {
            routers.put(errorListener, errorListener.router(publisherPostProcessor, continueCallback, propagateCallback));
        }
        return new ExceptionRouter(){

            @Override
            public void dispose() {
                routers.values().forEach(r -> LifecycleUtils.disposeIfNeeded(r, ErrorHandler.this.logger));
            }

            @Override
            public void accept(Exception error) {
                MessagingException messagingError = (MessagingException)error;
                CoreEvent event = messagingError.getEvent();
                try {
                    for (MessagingExceptionHandlerAcceptor errorListener : ErrorHandler.this.exceptionListeners) {
                        if (!errorListener.accept(event)) continue;
                        ((Consumer)routers.get(errorListener)).accept(error);
                        return;
                    }
                    throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(ErrorHandler.MUST_ACCEPT_ANY_EVENT_MESSAGE));
                }
                catch (Exception e) {
                    propagateCallback.accept(ErrorHandler.this.messagingExceptionResolver.resolve(new MessagingException(event, (Throwable)e, (Component)ErrorHandler.this), ErrorHandler.this.errorTypeLocator, ErrorHandler.this.exceptionContextProviders));
                    return;
                }
            }
        };
    }

    @Override
    public Publisher<CoreEvent> apply(Exception exception) {
        if (exception instanceof MessagingException) {
            CoreEvent event = ((MessagingException)exception).getEvent();
            ((MessagingException)exception).setProcessedEvent(event);
            try {
                for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
                    if (!exceptionListener.accept(event)) continue;
                    return exceptionListener.apply(exception);
                }
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(MUST_ACCEPT_ANY_EVENT_MESSAGE));
            }
            catch (Exception e) {
                return Mono.error((Throwable)this.messagingExceptionResolver.resolve(new MessagingException(event, (Throwable)e, (Component)this), this.errorTypeLocator, this.exceptionContextProviders));
            }
        }
        return Mono.error((Throwable)exception);
    }

    @Override
    protected List<MessagingExceptionHandlerAcceptor> getOwnedObjects() {
        return this.exceptionListeners != null ? Collections.unmodifiableList(this.exceptionListeners) : Collections.emptyList();
    }

    @Override
    public boolean accept(CoreEvent event) {
        return true;
    }

    @Override
    public boolean acceptsAll() {
        return true;
    }

    private void addCriticalErrorHandler() {
        this.exceptionListeners.add(0, new OnCriticalErrorHandler(new SingleErrorTypeMatcher(this.errorTypeRepository.getErrorType(Errors.ComponentIdentifiers.Unhandleable.OVERLOAD).get())));
    }

    private void addDefaultErrorHandlerIfRequired() throws InitialisationException {
        MessagingExceptionHandlerAcceptor lastAcceptor = this.exceptionListeners.get(this.exceptionListeners.size() - 1);
        if (lastAcceptor.acceptsAll() || this.matchesAny(lastAcceptor)) {
            return;
        }
        String defaultErrorHandlerName = this.getMuleContext().getConfiguration().getDefaultErrorHandlerName();
        if (defaultErrorHandlerName != null && defaultErrorHandlerName.equals(this.name)) {
            this.logger.warn("Default 'error-handler' should include a final \"catch-all\" 'on-error-propagate'. Attempting implicit injection.");
        }
        OnErrorPropagateHandler acceptsAllOnErrorPropagate = new OnErrorPropagateHandler();
        acceptsAllOnErrorPropagate.setRootContainerName(this.getRootContainerLocation().toString());
        acceptsAllOnErrorPropagate.setNotificationFirer(this.notificationDispatcher);
        LifecycleUtils.initialiseIfNeeded(acceptsAllOnErrorPropagate, this.muleContext);
        if (this.getLocation() != null && this.shouldAddLocationToDefaultErrorHandler()) {
            acceptsAllOnErrorPropagate.setFlowLocation(this.getLocation());
        }
        this.exceptionListeners.add(acceptsAllOnErrorPropagate);
    }

    public boolean shouldAddLocationToDefaultErrorHandler() {
        return this.featureFlaggingService.isEnabled(MuleRuntimeFeature.DEFAULT_ERROR_HANDLER_NOT_ROLLBACK_IF_NOT_CORRESPONDING);
    }

    private boolean matchesAny(MessagingExceptionHandlerAcceptor acceptor) {
        return acceptor instanceof OnErrorPropagateHandler && ((OnErrorPropagateHandler)acceptor).acceptsErrorType(this.anyErrorType) && !((OnErrorPropagateHandler)acceptor).hasWhenExpression();
    }

    private void validateConfiguredExceptionStrategies() {
        this.validateOnlyLastAcceptsAll();
    }

    private void validateOnlyLastAcceptsAll() {
        for (int i = 0; i < this.exceptionListeners.size() - 1; ++i) {
            MessagingExceptionHandlerAcceptor acceptor = this.exceptionListeners.get(i);
            if (acceptor.acceptsAll()) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Only last <on-error> inside <error-handler> can accept any errors. Otherwise the following handlers will never execute."));
            }
            if (!this.matchesAny(acceptor)) continue;
            this.logger.warn("Only the last <on-error> inside an <error-handler> should accept any errors. Otherwise the following handlers will never execute.");
        }
    }

    public void setExceptionListeners(List<MessagingExceptionHandlerAcceptor> exceptionListeners) {
        this.exceptionListeners = new CopyOnWriteArrayList<MessagingExceptionHandlerAcceptor>(exceptionListeners);
    }

    public List<MessagingExceptionHandlerAcceptor> getExceptionListeners() {
        return Collections.unmodifiableList(this.exceptionListeners);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setRootContainerName(String rootContainerName) {
        ComponentAnnotations.updateRootContainerName(rootContainerName, this);
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!(exceptionListener instanceof TemplateOnErrorHandler)) continue;
            ((TemplateOnErrorHandler)exceptionListener).setRootContainerName(rootContainerName);
        }
    }

    public void setStatistics(FlowConstructStatistics flowStatistics) {
        for (MessagingExceptionHandlerAcceptor exceptionListener : this.exceptionListeners) {
            if (!(exceptionListener instanceof AbstractExceptionListener)) continue;
            ((AbstractExceptionListener)((Object)exceptionListener)).setStatistics(flowStatistics);
        }
    }

    public void setExceptionListenersLocation(ComponentLocation flowLocation) {
        List<MessagingExceptionHandlerAcceptor> listeners = this.getExceptionListeners().stream().map(exceptionListener -> exceptionListener instanceof TemplateOnErrorHandler ? ((TemplateOnErrorHandler)exceptionListener).duplicateFor(flowLocation) : exceptionListener).collect(Collectors.toList());
        this.setExceptionListeners(listeners);
    }
}

