/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.config.resolver;

import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.visitor.BasicTypeMetadataVisitor;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.TypeSafeValueResolverWrapper;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.springframework.core.convert.ConversionService;
import org.springframework.core.convert.support.DefaultConversionService;

public class BasicTypeValueResolverFactoryTypeVisitor
extends BasicTypeMetadataVisitor {
    private static final ConversionService CONVERSION_SERVICE = new DefaultConversionService();
    private final Reference<ValueResolver> resolverValueHolder = new Reference();
    private final String parameterName;
    private final Object value;
    private final Class<?> expectedClass;

    public BasicTypeValueResolverFactoryTypeVisitor(String parameterName, Object value, Class<?> expectedClass) {
        this.parameterName = parameterName;
        this.value = value;
        this.expectedClass = expectedClass;
    }

    public ValueResolver getResolver() {
        return this.resolverValueHolder.get();
    }

    protected void setResolver(ValueResolver resolver) {
        this.resolverValueHolder.set(resolver);
    }

    protected Object getValue() {
        return this.value;
    }

    protected Class<?> getExpectedClass() {
        return this.expectedClass;
    }

    @Override
    protected void visitBasicType(MetadataType metadataType) {
        this.resolverValueHolder.set(this.basicTypeResolver());
    }

    public ValueResolver basicTypeResolver() {
        if (CONVERSION_SERVICE.canConvert(this.value.getClass(), this.expectedClass)) {
            return new StaticValueResolver<Object>(this.convertSimpleValue(this.value, this.expectedClass, this.parameterName));
        }
        return this.defaultResolver();
    }

    @Override
    protected void defaultVisit(MetadataType metadataType) {
        this.resolverValueHolder.set(this.defaultResolver());
    }

    private ValueResolver<?> defaultResolver() {
        return new TypeSafeValueResolverWrapper(new StaticValueResolver<Object>(this.value), this.expectedClass);
    }

    private Object convertSimpleValue(Object value, Class<?> expectedClass, String parameterName) {
        try {
            return CONVERSION_SERVICE.convert(value, expectedClass);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(String.format("Could not transform simple value '%s' to type '%s' in parameter '%s'", value, expectedClass.getSimpleName(), parameterName));
        }
    }
}

