/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.outbound;

import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.internal.routing.MessageSequence;

public class PartitionedMessageSequence<Q>
implements MessageSequence<Collection<Q>> {
    private MessageSequence<Q> delegate;
    private int groupSize;

    public PartitionedMessageSequence(MessageSequence<Q> seq, int groupSize) {
        if (groupSize <= 1) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("group size must be greater than 1"));
        }
        this.delegate = seq;
        this.groupSize = groupSize;
    }

    @Override
    public Integer size() {
        return this.delegate.size() == null ? null : Integer.valueOf(this.delegate.size() / this.groupSize + (this.delegate.size() % this.groupSize > 0 ? 1 : 0));
    }

    @Override
    public boolean hasNext() {
        return this.delegate.hasNext();
    }

    @Override
    public Collection<Q> next() {
        if (!this.delegate.hasNext()) {
            throw new NoSuchElementException();
        }
        ArrayList<Q> batch = new ArrayList<Q>();
        for (int i = this.groupSize; i > 0 && this.delegate.hasNext(); --i) {
            batch.add(this.delegate.next());
        }
        return batch;
    }

    @Override
    public boolean isEmpty() {
        return !this.hasNext();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

