/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal;

import java.util.List;
import java.util.Optional;
import org.mule.runtime.api.artifact.Registry;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.config.ConfigurationException;
import org.mule.runtime.core.api.processor.Processor;
import org.mule.runtime.core.api.retry.policy.RetryPolicyTemplate;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.internal.exception.EnrichedErrorMapping;
import org.mule.runtime.core.internal.policy.PolicyManager;
import org.mule.runtime.dsl.api.component.AttributeDefinition;
import org.mule.runtime.dsl.api.component.ComponentBuildingDefinition;
import org.mule.runtime.dsl.api.component.TypeDefinition;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.module.extension.internal.config.dsl.ComponentMessageProcessorObjectFactory;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionDefinitionParser;
import org.mule.runtime.module.extension.internal.config.dsl.ExtensionParsingContext;
import org.mule.runtime.module.extension.internal.runtime.operation.ComponentMessageProcessor;

public abstract class AbstractComponentDefinitionParser<T extends ComponentModel>
extends ExtensionDefinitionParser {
    private final ExtensionModel extensionModel;
    private final T componentModel;
    private final DslElementSyntax operationDsl;

    public AbstractComponentDefinitionParser(ComponentBuildingDefinition.Builder definition, ExtensionModel extensionModel, T componentModel, DslSyntaxResolver dslSyntaxResolver, ExtensionParsingContext parsingContext) {
        super(definition, dslSyntaxResolver, parsingContext);
        this.extensionModel = extensionModel;
        this.componentModel = componentModel;
        this.operationDsl = dslSyntaxResolver.resolve((NamedObject)componentModel);
    }

    @Override
    protected ComponentBuildingDefinition.Builder doParse(ComponentBuildingDefinition.Builder definitionBuilder) throws ConfigurationException {
        Optional<NestableElementModel> nestedChain;
        ComponentBuildingDefinition.Builder<ComponentMessageProcessor> finalBuilder = definitionBuilder.withIdentifier(this.operationDsl.getElementName()).withTypeDefinition(TypeDefinition.fromType(this.getMessageProcessorType())).withObjectFactoryType(this.getMessageProcessorFactoryType()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.extensionModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromFixedValue(this.componentModel).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(MuleContext.class).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(Registry.class).build()).withConstructorParameterDefinition(AttributeDefinition.Builder.fromReferenceObject(PolicyManager.class).build()).withSetterParameterDefinition("cursorProviderFactory", AttributeDefinition.Builder.fromChildConfiguration(CursorProviderFactory.class).build()).withSetterParameterDefinition("retryPolicyTemplate", AttributeDefinition.Builder.fromChildConfiguration(RetryPolicyTemplate.class).build());
        if (this.hasOutputGroup()) {
            finalBuilder = finalBuilder.withSetterParameterDefinition("target", AttributeDefinition.Builder.fromSimpleParameter("target").build()).withSetterParameterDefinition("targetValue", AttributeDefinition.Builder.fromSimpleParameter("targetValue").build());
        }
        if (this.hasErrorMappingsGroup()) {
            finalBuilder = finalBuilder.withSetterParameterDefinition("errorMappings", AttributeDefinition.Builder.fromChildCollectionConfiguration(EnrichedErrorMapping.class).build());
        }
        if ((nestedChain = this.componentModel.getNestedComponents().stream().filter(c -> c instanceof NestedChainModel).findFirst()).isPresent()) {
            finalBuilder = finalBuilder.withSetterParameterDefinition("nestedProcessors", AttributeDefinition.Builder.fromChildCollectionConfiguration(Processor.class).build());
            this.parseParameters(this.componentModel.getAllParameterModels());
        } else {
            List<ParameterGroupModel> inlineGroups = this.getInlineGroups((ParameterizedModel)this.componentModel);
            this.parseParameters(this.getFlatParameters(inlineGroups, this.componentModel.getAllParameterModels()));
            for (ParameterGroupModel group : inlineGroups) {
                this.parseInlineParameterGroup(group);
            }
            this.parseNestedComponents(this.componentModel.getNestedComponents());
        }
        return finalBuilder;
    }

    protected boolean hasErrorMappingsGroup() {
        return false;
    }

    protected boolean hasOutputGroup() {
        return false;
    }

    protected abstract Class<? extends ComponentMessageProcessor> getMessageProcessorType();

    protected abstract Class<? extends ComponentMessageProcessorObjectFactory> getMessageProcessorFactoryType();

    public final T getComponentModel() {
        return this.componentModel;
    }
}

