/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.soap.internal.loader;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Type;
import java.util.List;
import org.mule.metadata.api.ClassTypeLoader;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.model.connection.ConnectionManagementType;
import org.mule.runtime.api.meta.model.declaration.fluent.ConfigurationDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.ConnectionProviderDeclarer;
import org.mule.runtime.api.meta.model.declaration.fluent.NamedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclarer;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeLoaderFactory;
import org.mule.runtime.extension.api.soap.MessageDispatcherProvider;
import org.mule.runtime.module.extension.internal.loader.java.ParameterModelsLoaderDelegate;
import org.mule.runtime.module.extension.internal.loader.java.contributor.InfrastructureFieldContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.ParameterDeclarerContributor;
import org.mule.runtime.module.extension.internal.loader.java.contributor.StackableTypesParameterContributor;
import org.mule.runtime.module.extension.internal.loader.java.property.ConnectionTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingTypeModelProperty;
import org.mule.runtime.module.extension.internal.loader.utils.ParameterDeclarationContext;
import org.mule.runtime.module.extension.soap.internal.loader.type.runtime.SoapServiceProviderWrapper;
import org.mule.runtime.module.extension.soap.internal.runtime.connection.ForwardingSoapClient;

public class SoapServiceProviderDeclarer {
    public static final String TRANSPORT_PARAM = "Transport".toLowerCase();
    private final ParameterModelsLoaderDelegate parametersLoader;
    private final ClassTypeLoader typeLoader = ExtensionsTypeLoaderFactory.getDefault().createTypeLoader();

    SoapServiceProviderDeclarer() {
        this.parametersLoader = new ParameterModelsLoaderDelegate(this.getContributors(), this.typeLoader);
    }

    public void declare(ConfigurationDeclarer configDeclarer, SoapServiceProviderWrapper provider, boolean hasCustomTransports) {
        String description = provider.getDescription();
        ConnectionProviderDeclarer providerDeclarer = configDeclarer.withConnectionProvider(provider.getAlias()).describedAs(description).withModelProperty(new ConnectionTypeModelProperty(ForwardingSoapClient.class)).withModelProperty(new ImplementingTypeModelProperty(provider.getDeclaringClass().get())).withConnectionManagementType(ConnectionManagementType.POOLING).supportsConnectivityTesting(provider.supportsConnectivityTesting());
        ParameterDeclarationContext context = new ParameterDeclarationContext("Service Provider", (NamedDeclaration)providerDeclarer.getDeclaration());
        this.parametersLoader.declare(providerDeclarer, provider.getParameters(), context);
        if (hasCustomTransports) {
            ((ParameterDeclarer)((ParameterDeclarer)((ParameterDeclarer)providerDeclarer.onParameterGroup("Transport Configuration").withRequiredParameter(TRANSPORT_PARAM).withDisplayModel(DisplayModel.builder().displayName("Transport Configuration").build())).ofType(this.typeLoader.load((Type)((Object)MessageDispatcherProvider.class)))).withLayout(LayoutModel.builder().order(1).tabName("Transport").build())).withExpressionSupport(ExpressionSupport.NOT_SUPPORTED);
        }
    }

    private List<ParameterDeclarerContributor> getContributors() {
        return ImmutableList.of((Object)new InfrastructureFieldContributor(), (Object)StackableTypesParameterContributor.defaultContributor(this.typeLoader));
    }
}

