/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.xml.parsers.SAXParserFactory;
import org.mule.apache.xerces.xni.grammars.XMLGrammarPool;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.ErrorTypeRepository;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ImportedResource;
import org.mule.runtime.ast.api.NamespaceDefinition;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.util.BaseArtifactAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.internal.error.CompositeErrorTypeRepository;
import org.mule.runtime.ast.internal.xml.XmlNamespaceInfoProviderSupplier;
import org.mule.runtime.ast.internal.xml.reader.ComponentAstReader;
import org.mule.runtime.ast.internal.xml.resolver.CachingExtensionSchemaGenerator;
import org.mule.runtime.ast.internal.xml.resolver.ModuleDelegatingEntityResolver;
import org.mule.runtime.ast.internal.xml.resolver.ResolveEntityFailStrategy;
import org.mule.runtime.dsl.api.ConfigResource;
import org.mule.runtime.dsl.api.xml.XmlNamespaceInfoProvider;
import org.mule.runtime.dsl.api.xml.parser.ParsingPropertyResolver;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.mule.runtime.dsl.api.xml.parser.XmlConfigurationDocumentLoader;
import org.mule.runtime.dsl.internal.xerces.xni.parser.DefaultXmlGrammarPoolManager;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.helpers.DefaultHandler;

public class DefaultAstXmlParser
implements AstXmlParser {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultAstXmlParser.class);
    private static final SAXParserFactory SAX_PARSER_FACTORY = XMLSecureFactories.createDefault().getSAXParserFactory();
    private static final ComponentAstReader CONFIG_READER = new ComponentAstReader();
    private final XmlConfigurationDocumentLoader xmlConfigurationDocumentLoader;
    private final XMLGrammarPool grammarPool;
    private final EntityResolver entityResolver;
    private final XmlApplicationParser xmlApplicationParser;
    private final Set<ExtensionModel> extensionModels;
    private final ArtifactAst parentArtifact;
    private final ParsingPropertyResolver propertyResolver;

    public DefaultAstXmlParser(Set<ExtensionModel> extensionModels, ArtifactAst parentArtifact, Optional<ExtensionSchemaGenerator> schemaGenerator, ParsingPropertyResolver propertyResolver, ResolveEntityFailStrategy resolveEntityFailStrategy) {
        this.extensionModels = Collections.unmodifiableSet(new HashSet<ExtensionModel>(extensionModels));
        this.parentArtifact = parentArtifact;
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(this.extensionModels);
        this.xmlConfigurationDocumentLoader = schemaGenerator.isPresent() ? XmlConfigurationDocumentLoader.schemaValidatingDocumentLoader() : XmlConfigurationDocumentLoader.noValidationDocumentLoader();
        this.grammarPool = schemaGenerator.isPresent() ? (XMLGrammarPool)DefaultXmlGrammarPoolManager.getGrammarPool().orElse(null) : null;
        this.entityResolver = schemaGenerator.map(sg -> new ModuleDelegatingEntityResolver(extensionModels, new CachingExtensionSchemaGenerator((ExtensionSchemaGenerator)sg), dslResolvingContext, resolveEntityFailStrategy)).orElseGet(() -> new DefaultHandler());
        this.propertyResolver = propertyResolver;
        List<XmlNamespaceInfoProvider> namespaceInfoProviders = XmlNamespaceInfoProviderSupplier.createFromExtensionModels(extensionModels, Optional.of(cl -> StreamSupport.stream(ServiceLoader.load(XmlNamespaceInfoProvider.class, cl).spliterator(), false).collect(Collectors.toList())));
        this.xmlApplicationParser = new XmlApplicationParser(namespaceInfoProviders);
    }

    @Override
    public ArtifactAst parse(List<Pair<String, InputStream>> appXmlConfigInputStreams) {
        if (appXmlConfigInputStreams.isEmpty()) {
            throw new IllegalArgumentException("At least one 'appXmlConfigInputStream' must be provided");
        }
        LOGGER.debug("About to parse AST from inputStreams {}", appXmlConfigInputStreams);
        List<ConfigResource> baseAstResources = appXmlConfigInputStreams.stream().map(is -> this.inputStreamToConfigResource((String)is.getFirst(), (InputStream)is.getSecond())).collect(Collectors.toList());
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(this::doParse).collect(Collectors.toList())), baseAstResources);
    }

    @Override
    public ArtifactAst parse(String resourceName, InputStream appXmlConfigInputStream) {
        LOGGER.debug("About to parse AST from inputStream {}, {}", (Object)resourceName, (Object)appXmlConfigInputStream);
        ConfigResource baseAstResource = this.inputStreamToConfigResource(resourceName, appXmlConfigInputStream);
        return this.resolveImports(this.doParse(baseAstResource), Collections.singletonList(baseAstResource));
    }

    @Override
    public ArtifactAst parse(URI ... appXmlConfigUris) {
        if (appXmlConfigUris.length == 0) {
            throw new IllegalArgumentException("At least one 'appXmlConfigUri' must be provided");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to parse AST from uris {}", Arrays.asList(appXmlConfigUris));
        }
        List<ConfigResource> baseAstResources = Stream.of(appXmlConfigUris).map(this::uriToConfigResource).collect(Collectors.toList());
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(this::doParse).collect(Collectors.toList())), baseAstResources);
    }

    @Override
    public ArtifactAst parse(URL ... appXmlConfigUrls) {
        if (appXmlConfigUrls.length == 0) {
            throw new IllegalArgumentException("At least one 'appXmlConfigUrl' must be provided");
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to parse AST from urls {}", Arrays.asList(appXmlConfigUrls));
        }
        List<ConfigResource> baseAstResources = Stream.of(appXmlConfigUrls).map(this::urlToConfigResource).collect(Collectors.toList());
        return this.resolveImports(this.aggregateAsts(baseAstResources.stream().map(this::doParse).collect(Collectors.toList())), baseAstResources);
    }

    private ArtifactAst aggregateAsts(final List<ArtifactAst> parsedAstsList) {
        ArtifactAst aggregatedAst = parsedAstsList.size() == 1 ? parsedAstsList.get(0) : new BaseArtifactAst(){
            final LazyValue<Set<ExtensionModel>> dependencies = new LazyValue<Supplier<Set>>(() -> parsedAstsList.stream().flatMap(ast -> ast.dependencies().stream()).collect(Collectors.toSet()));
            final LazyValue<ErrorTypeRepository> errorTypeRepo = new LazyValue<Supplier<ErrorTypeRepository>>(() -> new CompositeErrorTypeRepository(parsedAstsList.stream().map(ArtifactAst::getErrorTypeRepository).collect(Collectors.toList())));
            final LazyValue<List<ComponentAst>> topLevelComponents = new LazyValue<Supplier<List>>(() -> parsedAstsList.stream().flatMap(ArtifactAst::topLevelComponentsStream).collect(Collectors.toList()));
            final LazyValue<List<ImportedResource>> importedResources = new LazyValue<Supplier<List>>(() -> parsedAstsList.stream().flatMap(ast -> ast.getImportedResources().stream()).collect(Collectors.toList()));

            @Override
            public Set<ExtensionModel> dependencies() {
                return this.dependencies.get();
            }

            @Override
            public Optional<ArtifactAst> getParent() {
                return Optional.ofNullable(DefaultAstXmlParser.this.parentArtifact);
            }

            @Override
            public List<ComponentAst> topLevelComponents() {
                return this.topLevelComponents.get();
            }

            @Override
            public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
                parsedAstsList.forEach(ast -> ast.updatePropertiesResolver(newPropertiesResolver));
            }

            @Override
            public ErrorTypeRepository getErrorTypeRepository() {
                return this.errorTypeRepo.get();
            }

            @Override
            public Collection<ImportedResource> getImportedResources() {
                return this.importedResources.get();
            }
        };
        return aggregatedAst;
    }

    private ArtifactAst resolveImports(final ArtifactAst base, List<ConfigResource> baseAstResources) {
        final LinkedHashMap<ConfigResource, ArtifactAst> importedConfigs = new LinkedHashMap<ConfigResource, ArtifactAst>();
        baseAstResources.forEach(r -> importedConfigs.put((ConfigResource)r, MuleAstUtils.emptyArtifact()));
        this.resolveImports(base, importedConfigs);
        if (importedConfigs.isEmpty()) {
            return base;
        }
        return new BaseArtifactAst(){
            final LazyValue<Set<ExtensionModel>> dependencies = new LazyValue<Supplier<Set>>(() -> Stream.concat(base.dependencies().stream(), importedConfigs.values().stream().flatMap(ast -> ast.dependencies().stream())).collect(Collectors.toSet()));
            final LazyValue<ErrorTypeRepository> errorTypeRepo = new LazyValue<Supplier<ErrorTypeRepository>>(() -> {
                List<ErrorTypeRepository> allErrorTypeRepos = importedConfigs.values().stream().map(ArtifactAst::getErrorTypeRepository).collect(Collectors.toList());
                allErrorTypeRepos.add(0, base.getErrorTypeRepository());
                return new CompositeErrorTypeRepository(allErrorTypeRepos);
            });

            @Override
            public Set<ExtensionModel> dependencies() {
                return this.dependencies.get();
            }

            @Override
            public Optional<ArtifactAst> getParent() {
                return Optional.ofNullable(DefaultAstXmlParser.this.parentArtifact);
            }

            @Override
            public Stream<ComponentAst> topLevelComponentsStream() {
                return Stream.concat(base.topLevelComponentsStream(), importedConfigs.values().stream().flatMap(ArtifactAst::topLevelComponentsStream));
            }

            @Override
            public List<ComponentAst> topLevelComponents() {
                return this.topLevelComponentsStream().collect(Collectors.toList());
            }

            @Override
            public void updatePropertiesResolver(UnaryOperator<String> newPropertiesResolver) {
                base.updatePropertiesResolver(newPropertiesResolver);
                importedConfigs.values().forEach(ast -> ast.updatePropertiesResolver(newPropertiesResolver));
            }

            @Override
            public ErrorTypeRepository getErrorTypeRepository() {
                return this.errorTypeRepo.get();
            }

            @Override
            public NamespaceDefinition namespaceDefinition() {
                return base.namespaceDefinition();
            }

            @Override
            public Collection<ImportedResource> getImportedResources() {
                return Stream.concat(base.getImportedResources().stream(), importedConfigs.values().stream().flatMap(ast -> ast.getImportedResources().stream())).collect(Collectors.toList());
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private ArtifactAst doParse(ConfigResource resource) {
        int i;
        NodeList children;
        ArtifactAstBuilder astBuilder;
        Throwable throwable;
        InputStream inputStream;
        block23: {
            try {
                inputStream = resource.getInputStream();
                throwable = null;
                try {
                    Document document = this.xmlConfigurationDocumentLoader.loadDocument(() -> SAX_PARSER_FACTORY, this.entityResolver, resource.getResourceName(), inputStream, this.grammarPool);
                    astBuilder = ArtifactAstBuilder.builder(this.extensionModels, Optional.ofNullable(this.parentArtifact), this.propertyResolver::resolveProperty);
                    Element rootElement = document.getDocumentElement();
                    String identifier = this.xmlApplicationParser.parseIdentifier(rootElement);
                    if (identifier.equals(MULE_ROOT_IDENTIFIER.getName()) || identifier.equals(DOMAIN_ROOT_IDENTIFIER.getName())) {
                        children = rootElement.getChildNodes();
                        i = 0;
                        break block23;
                    }
                    CONFIG_READER.processAttributes(astBuilder, rootElement);
                    try {
                        CONFIG_READER.extractComponentDefinitionModel(this.xmlApplicationParser, rootElement, resource.getResourceName(), astBuilder.addTopLevelComponent(), astBuilder::createMetadataBuilder);
                        return astBuilder.build();
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception extracting definition model for component {}.", rootElement.getTagName()), (Throwable)e);
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (IOException e) {
                throw new MuleRuntimeException(e);
            }
        }
        while (i < children.getLength()) {
            Node child = children.item(i);
            if (child instanceof Element) {
                CONFIG_READER.processAttributes(astBuilder, (Element)child);
                if (IMPORT_IDENTIFIER.getName().equals(child.getNodeName())) {
                    CONFIG_READER.extractImport(astBuilder, (Element)child, resource.getResourceName(), astBuilder::createMetadataBuilder);
                } else {
                    try {
                        CONFIG_READER.extractComponentDefinitionModel(this.xmlApplicationParser, (Element)child, resource.getResourceName(), astBuilder.addTopLevelComponent(), astBuilder::createMetadataBuilder);
                    }
                    catch (Exception e) {
                        throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Exception extracting definition model for component {}.", ((Element)child).getTagName()), (Throwable)e);
                    }
                }
            }
            ++i;
        }
        return astBuilder.build();
        finally {
            if (inputStream != null) {
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                } else {
                    inputStream.close();
                }
            }
        }
    }

    private void resolveImports(ArtifactAst parsedConfig, Map<ConfigResource, ArtifactAst> alreadyResolvedConfigFiles) {
        parsedConfig.getImportedResources().stream().map(ImportedResource::getResourceLocation).map(this.propertyResolver::resolveProperty).map(importFile -> Optional.ofNullable(Thread.currentThread().getContextClassLoader().getResourceAsStream((String)importFile)).map(stream -> new ConfigResource((String)importFile, (InputStream)stream)).orElseThrow(() -> new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Could not find imported resource '%s'", importFile))))).filter(importedConfigResource -> !alreadyResolvedConfigFiles.containsKey(importedConfigResource)).forEach(importedConfigResource -> {
            LOGGER.debug("Resolving import {}", (Object)importedConfigResource.getResourceName());
            ArtifactAst parsedImportedConfig = this.doParse((ConfigResource)importedConfigResource);
            alreadyResolvedConfigFiles.put((ConfigResource)importedConfigResource, parsedImportedConfig);
            this.resolveImports(parsedImportedConfig, alreadyResolvedConfigFiles);
        });
    }

    private ConfigResource uriToConfigResource(URI appXmlConfig) {
        URL appXmlConfigUrl;
        try {
            appXmlConfigUrl = appXmlConfig.toURL();
        }
        catch (MalformedURLException e) {
            throw new MuleRuntimeException(e);
        }
        return this.urlToConfigResource(appXmlConfigUrl);
    }

    private ConfigResource urlToConfigResource(URL appXmlConfigUrl) {
        ConfigResource configResource = new ConfigResource(appXmlConfigUrl);
        try {
            configResource.getInputStream();
        }
        catch (IOException e) {
            throw new MuleRuntimeException(e);
        }
        return configResource;
    }

    private ConfigResource inputStreamToConfigResource(String resourceName, InputStream appXmlConfigInputStream) {
        return new ConfigResource(resourceName, appXmlConfigInputStream);
    }
}

