/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml.property;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.operation.OperationModel;

public class PrivateOperationsModelProperty
implements ModelProperty {
    private static final long serialVersionUID = -1574428794005821951L;
    private final Map<String, OperationModel> privateOperationsModels;

    public PrivateOperationsModelProperty(List<OperationModel> privateOperationsModels) {
        this.privateOperationsModels = privateOperationsModels.stream().collect(Collectors.toMap(opModel -> opModel.getName(), opModel -> opModel));
    }

    public Optional<OperationModel> getOperationModel(String name) {
        return Optional.ofNullable(this.privateOperationsModels.get(name));
    }

    public Collection<String> getOperationNames() {
        return this.privateOperationsModels.keySet();
    }

    @Override
    public String getName() {
        return "privateOperationsModelProperty";
    }

    @Override
    public boolean isPublic() {
        return false;
    }
}

