/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.values;

import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.value.Value;
import org.mule.runtime.extension.api.values.ImmutableValue;
import org.mule.sdk.api.annotation.MinMuleVersion;

@MinMuleVersion(value="4.1")
public class ValueBuilder {
    private final String id;
    private final Set<ValueBuilder> childs = new LinkedHashSet<ValueBuilder>();
    private String displayName;
    private String partName = "";

    private ValueBuilder(String id) {
        this.id = id;
    }

    private ValueBuilder(String id, String partName) {
        this.id = id;
        this.partName = partName;
    }

    public static ValueBuilder newValue(String id) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(id), "The ID can't be empty");
        return new ValueBuilder(id);
    }

    public static ValueBuilder newValue(String id, String partName) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(id), "The ID can't be empty");
        return new ValueBuilder(id, partName);
    }

    public static Set<Value> getValuesFor(String ... values) {
        return ValueBuilder.getValuesFor(Arrays.stream(values));
    }

    public static Set<Value> getValuesFor(List<String> values) {
        return ValueBuilder.getValuesFor(values.stream());
    }

    public static Set<Value> getValuesFor(Stream<String> values) {
        return values.map(id -> {
            Preconditions.checkArgument(StringUtils.isNotEmpty(id), "The ID can't be empty");
            return id;
        }).map(ValueBuilder::newValue).map(ValueBuilder::build).collect(Collectors.toSet());
    }

    public static Set<Value> getValuesFor(Map<String, String> values) {
        return values.entrySet().stream().map(entry -> {
            Preconditions.checkArgument(StringUtils.isNotEmpty((String)entry.getKey()), "The ID can't be empty");
            Preconditions.checkArgument(StringUtils.isNotEmpty((String)entry.getValue()), "The displayName can't be empty");
            return ValueBuilder.newValue((String)entry.getKey()).withDisplayName((String)entry.getValue()).build();
        }).collect(Collectors.toSet());
    }

    public ValueBuilder withDisplayName(String displayName) {
        Preconditions.checkArgument(StringUtils.isNotEmpty(displayName), "The displayName can't be empty");
        this.displayName = displayName;
        return this;
    }

    public ValueBuilder withChild(ValueBuilder valueBuilder) {
        this.childs.add(valueBuilder);
        return this;
    }

    protected void setPartName(String partName) {
        this.partName = partName;
    }

    public Value build() {
        String name = StringUtils.isNotEmpty(this.displayName) ? this.displayName : this.id;
        return new ImmutableValue(this.id, name, this.childs.stream().map(ValueBuilder::build).collect(Collectors.toCollection(LinkedHashSet::new)), this.partName);
    }
}

