/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.impl.internal.policy;

import java.io.File;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.deployment.model.api.plugin.ArtifactPlugin;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplate;
import org.mule.runtime.deployment.model.api.policy.PolicyTemplateDescriptor;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.DisposableClassLoader;
import org.mule.runtime.module.artifact.api.classloader.RegionClassLoader;

public class DefaultPolicyTemplate
implements PolicyTemplate {
    private final String artifactId;
    private final PolicyTemplateDescriptor descriptor;
    private final ArtifactClassLoader policyClassLoader;
    private final List<ArtifactPlugin> artifactPlugins;
    private final List<ArtifactPlugin> ownArtifactPlugins;

    public DefaultPolicyTemplate(String artifactId, PolicyTemplateDescriptor descriptor, ArtifactClassLoader policyClassLoader, List<ArtifactPlugin> artifactPlugins, List<ArtifactPlugin> ownArtifactPlugins) {
        Preconditions.checkArgument(!StringUtils.isEmpty((CharSequence)artifactId), "artifactId cannot be empty");
        Preconditions.checkArgument(descriptor != null, "descriptor cannot be null");
        Preconditions.checkArgument(policyClassLoader != null, "policyClassLoader cannot be null");
        Preconditions.checkArgument(artifactPlugins != null, "artifactPlugins cannot be null");
        Preconditions.checkArgument(ownArtifactPlugins != null, "ownArtifactPlugin cannot be null");
        this.artifactId = artifactId;
        this.descriptor = descriptor;
        this.policyClassLoader = policyClassLoader;
        this.artifactPlugins = artifactPlugins;
        this.ownArtifactPlugins = ownArtifactPlugins;
    }

    @Override
    public String getArtifactName() {
        return this.descriptor.getName();
    }

    @Override
    public String getArtifactId() {
        return this.artifactId;
    }

    @Override
    public PolicyTemplateDescriptor getDescriptor() {
        return this.descriptor;
    }

    @Override
    public File[] getResourceFiles() {
        return new File[0];
    }

    @Override
    public ArtifactClassLoader getArtifactClassLoader() {
        return this.policyClassLoader;
    }

    @Override
    public void dispose() {
        if (DefaultPolicyTemplate.isRegionClassLoaderMember((ClassLoader)((Object)this.policyClassLoader))) {
            ((DisposableClassLoader)((Object)((ClassLoader)((Object)this.policyClassLoader)).getParent())).dispose();
        } else if (this.policyClassLoader instanceof DisposableClassLoader) {
            this.policyClassLoader.dispose();
        }
    }

    private static boolean isRegionClassLoaderMember(ClassLoader classLoader) {
        return !(classLoader instanceof RegionClassLoader) && classLoader.getParent() instanceof RegionClassLoader;
    }

    @Override
    public List<ArtifactPlugin> getArtifactPlugins() {
        return this.artifactPlugins;
    }

    @Override
    public List<ArtifactPlugin> getOwnArtifactPlugins() {
        return this.ownArtifactPlugins;
    }
}

