/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.lang.annotation.Annotation;
import java.util.Optional;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.extension.api.annotation.source.ClusterSupport;
import org.mule.runtime.extension.api.annotation.source.SourceClusterSupport;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.internal.loader.util.InfrastructureParameterBuilder;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public class ClusterSupportEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.WIRING;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new IdempotentDeclarationWalker(){

            @Override
            protected void onSource(SourceDeclaration declaration) {
                ClusterSupport annotation = ClusterSupportEnricher.this.getAnnotation(declaration, ClusterSupport.class).orElse(null);
                if (annotation != null) {
                    SourceClusterSupport clusterSupport = annotation.value();
                    if (clusterSupport == SourceClusterSupport.NOT_SUPPORTED) {
                        declaration.setRunsOnPrimaryNodeOnly(true);
                    } else {
                        declaration.setRunsOnPrimaryNodeOnly(false);
                        InfrastructureParameterBuilder.addPrimaryNodeParameter(declaration, clusterSupport == SourceClusterSupport.DEFAULT_PRIMARY_NODE_ONLY);
                    }
                } else {
                    declaration.setRunsOnPrimaryNodeOnly(false);
                    InfrastructureParameterBuilder.addPrimaryNodeParameter(declaration, false);
                }
            }
        }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
    }

    private <T extends Annotation> Optional<T> getAnnotation(SourceDeclaration declaration, Class<T> annotation) {
        return declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).map(ExtensionTypeDescriptorModelProperty::getType).filter(type -> type.isAnnotatedWith(annotation)).flatMap(type -> type.getAnnotation(annotation));
    }
}

