/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import org.mule.runtime.api.meta.model.declaration.fluent.BaseDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExecutableComponentDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.OperationDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ParameterizedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceCallbackDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.SourceDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.TypedDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.WithOutputDeclaration;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.metadata.resolving.AttributesTypeResolver;
import org.mule.runtime.api.metadata.resolving.InputTypeResolver;
import org.mule.runtime.api.metadata.resolving.NamedTypeResolver;
import org.mule.runtime.api.metadata.resolving.OutputTypeResolver;
import org.mule.runtime.api.metadata.resolving.PartialTypeKeysResolver;
import org.mule.runtime.api.metadata.resolving.TypeKeysResolver;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.core.internal.metadata.DefaultMetadataResolverFactory;
import org.mule.runtime.core.internal.metadata.NullMetadataResolverFactory;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyId;
import org.mule.runtime.extension.api.annotation.metadata.MetadataKeyPart;
import org.mule.runtime.extension.api.annotation.param.Query;
import org.mule.runtime.extension.api.declaration.fluent.util.IdempotentDeclarationWalker;
import org.mule.runtime.extension.api.exception.IllegalParameterModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricher;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.extension.api.metadata.MetadataResolverFactory;
import org.mule.runtime.extension.api.metadata.NullMetadataResolver;
import org.mule.runtime.extension.api.property.MetadataKeyIdModelProperty;
import org.mule.runtime.extension.api.property.MetadataKeyPartModelProperty;
import org.mule.runtime.extension.api.property.TypeResolversInformationModelProperty;
import org.mule.runtime.module.extension.api.loader.java.type.ExtensionParameter;
import org.mule.runtime.module.extension.api.loader.java.type.MethodElement;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.property.ImplementingParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.MetadataResolverFactoryModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.property.QueryParameterModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionOperationDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionParameterDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;
import org.mule.runtime.module.extension.internal.metadata.DefaultMetadataScopeAdapter;
import org.mule.runtime.module.extension.internal.metadata.MetadataScopeAdapter;
import org.mule.runtime.module.extension.internal.metadata.QueryMetadataResolverFactory;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

public class DynamicMetadataDeclarationEnricher
implements DeclarationEnricher {
    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        new EnricherDelegate().enrich(extensionLoadingContext);
    }

    private static class EnricherDelegate
    extends AbstractAnnotatedDeclarationEnricher {
        private static final NullMetadataResolver nullMetadataResolver = new NullMetadataResolver();
        private Type extensionType;

        private EnricherDelegate() {
        }

        @Override
        public void enrich(ExtensionLoadingContext extensionLoadingContext) {
            Object declaration = extensionLoadingContext.getExtensionDeclarer().getDeclaration();
            if (!IntrospectionUtils.isASTMode(declaration)) {
                Optional<ExtensionTypeDescriptorModelProperty> property = ((BaseDeclaration)declaration).getModelProperty(ExtensionTypeDescriptorModelProperty.class);
                if (!property.isPresent()) {
                    return;
                }
                this.extensionType = property.get().getType();
                new IdempotentDeclarationWalker(){

                    @Override
                    public void onSource(SourceDeclaration declaration) {
                        this.enrichSourceMetadata(declaration);
                    }

                    @Override
                    public void onOperation(OperationDeclaration declaration) {
                        this.enrichOperationMetadata(declaration);
                    }
                }.walk((ExtensionDeclaration)extensionLoadingContext.getExtensionDeclarer().getDeclaration());
            }
        }

        private void enrichSourceMetadata(SourceDeclaration declaration) {
            declaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class).ifPresent(prop -> {
                Type sourceType = prop.getType();
                DefaultMetadataScopeAdapter metadataScope = new DefaultMetadataScopeAdapter(this.extensionType, sourceType, declaration);
                this.enrichResolversInformation(declaration, metadataScope);
                this.enrichSuccesSourceCallbackMetadata(declaration);
                this.enrichErrorSourceCallbackMetadata(declaration);
            });
        }

        private void enrichErrorSourceCallbackMetadata(SourceDeclaration declaration) {
            declaration.getSuccessCallback().ifPresent(sourceCallbackDeclaration -> this.enrichSourceCallbackMetadata(declaration, (SourceCallbackDeclaration)sourceCallbackDeclaration));
        }

        private void enrichSuccesSourceCallbackMetadata(SourceDeclaration declaration) {
            declaration.getErrorCallback().ifPresent(sourceCallbackDeclaration -> this.enrichSourceCallbackMetadata(declaration, (SourceCallbackDeclaration)sourceCallbackDeclaration));
        }

        private void enrichSourceCallbackMetadata(SourceDeclaration sourceDeclaration, SourceCallbackDeclaration sourceCallbackDeclaration) {
            DefaultMetadataScopeAdapter metadataScope = new DefaultMetadataScopeAdapter(sourceCallbackDeclaration);
            this.enrichResolversInformation(sourceDeclaration, sourceCallbackDeclaration, metadataScope);
        }

        private void enrichOperationMetadata(OperationDeclaration declaration) {
            declaration.getModelProperty(ExtensionOperationDescriptorModelProperty.class).map(ExtensionOperationDescriptorModelProperty::getOperationElement).ifPresent(operation -> {
                if (operation.isAnnotatedWith(Query.class)) {
                    this.enrichWithDsql(declaration, (MethodElement)operation);
                } else {
                    DefaultMetadataScopeAdapter metadataScope = new DefaultMetadataScopeAdapter(this.extensionType, (MethodElement)operation, declaration);
                    this.enrichResolversInformation(declaration, metadataScope);
                }
            });
        }

        private void enrichResolversInformation(SourceDeclaration sourceDeclaration, SourceCallbackDeclaration sourceCallbackDeclaration, MetadataScopeAdapter metadataScope) {
            String categoryName = this.getCategoryName(metadataScope);
            this.declareResolversInformation(sourceCallbackDeclaration, metadataScope, categoryName, sourceDeclaration.isRequiresConnection());
            this.declareMetadataResolverFactory(sourceCallbackDeclaration, metadataScope);
        }

        private void enrichResolversInformation(ExecutableComponentDeclaration<?> declaration, MetadataScopeAdapter metadataScope) {
            String categoryName = this.getCategoryName(metadataScope);
            this.declareResolversInformation(declaration, metadataScope, categoryName);
            this.declareMetadataResolverFactory(declaration, metadataScope, categoryName);
            this.enrichMetadataKeyParameters(declaration, metadataScope.getKeysResolver().get());
        }

        private void enrichMetadataKeyParameters(ParameterizedDeclaration<?> declaration, TypeKeysResolver typeKeysResolver) {
            declaration.getAllParameters().forEach(paramDeclaration -> paramDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class).ifPresent(modelProperty -> this.parseMetadataKeyAnnotations(modelProperty.getExtensionParameter(), (BaseDeclaration)paramDeclaration, typeKeysResolver)));
        }

        private void declareResolversInformation(ExecutableComponentDeclaration<? extends ComponentDeclaration> declaration, MetadataScopeAdapter metadataScope, String categoryName) {
            this.declareResolversInformation(declaration, metadataScope, categoryName, declaration.isRequiresConnection());
        }

        private void declareResolversInformation(BaseDeclaration declaration, MetadataScopeAdapter metadataScope, String categoryName, boolean requiresConnection) {
            if (metadataScope.isCustomScope()) {
                Map<String, String> inputResolversByParam = metadataScope.getInputResolvers().entrySet().stream().collect(Collectors.toImmutableMap(Map.Entry::getKey, e -> ((InputTypeResolver)((Supplier)e.getValue()).get()).getResolverName()));
                String outputResolver = metadataScope.getOutputResolver().get().getResolverName();
                String attributesResolver = metadataScope.getAttributesResolver().get().getResolverName();
                TypeKeysResolver typeKeysResolver = metadataScope.getKeysResolver().get();
                String keysResolver = typeKeysResolver.getResolverName();
                declaration.addModelProperty(new TypeResolversInformationModelProperty(categoryName, inputResolversByParam, outputResolver, attributesResolver, keysResolver, requiresConnection, requiresConnection, typeKeysResolver instanceof PartialTypeKeysResolver));
            }
        }

        private void declareMetadataResolverFactory(ComponentDeclaration<? extends ComponentDeclaration> declaration, MetadataScopeAdapter metadataScope, String categoryName) {
            MetadataResolverFactory metadataResolverFactory = this.getMetadataResolverFactory(metadataScope);
            declaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> metadataResolverFactory));
            this.declareMetadataKeyId(declaration, categoryName);
            this.declareInputResolvers(declaration, metadataScope);
            if (declaration instanceof WithOutputDeclaration) {
                this.declareOutputResolvers((WithOutputDeclaration)((Object)declaration), metadataScope);
            }
        }

        private void declareMetadataResolverFactory(SourceCallbackDeclaration sourceCallbackDeclaration, MetadataScopeAdapter metadataScope) {
            MetadataResolverFactory metadataResolverFactory = this.getMetadataResolverFactory(metadataScope);
            sourceCallbackDeclaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> metadataResolverFactory));
            this.declareInputResolvers(sourceCallbackDeclaration, metadataScope);
        }

        private void enrichWithDsql(OperationDeclaration declaration, MethodElement method) {
            Query query = method.getAnnotation(Query.class).get();
            final QueryMetadataResolverFactory resolverFactory = new QueryMetadataResolverFactory(query.nativeOutputResolver(), query.entityResolver());
            declaration.addModelProperty(new MetadataResolverFactoryModelProperty(() -> resolverFactory));
            this.addQueryModelProperties(declaration, query);
            this.declareDynamicType(declaration.getOutput());
            this.declareMetadataKeyId(declaration, null);
            this.enrichMetadataKeyParameters(declaration, nullMetadataResolver);
            MetadataScopeAdapter metadataScope = new MetadataScopeAdapter(){
                private OutputTypeResolver outputResolver;
                {
                    this.outputResolver = resolverFactory.getOutputResolver();
                }

                @Override
                public boolean hasInputResolvers() {
                    return false;
                }

                @Override
                public boolean hasOutputResolver() {
                    return true;
                }

                @Override
                public boolean hasAttributesResolver() {
                    return false;
                }

                @Override
                public Supplier<? extends TypeKeysResolver> getKeysResolver() {
                    return () -> nullMetadataResolver;
                }

                @Override
                public Map<String, Supplier<? extends InputTypeResolver>> getInputResolvers() {
                    return Collections.emptyMap();
                }

                @Override
                public Supplier<? extends OutputTypeResolver> getOutputResolver() {
                    return () -> this.outputResolver;
                }

                @Override
                public Supplier<? extends AttributesTypeResolver> getAttributesResolver() {
                    return () -> nullMetadataResolver;
                }
            };
            this.declareResolversInformation(declaration, metadataScope, this.getCategoryName(metadataScope));
        }

        private void addQueryModelProperties(OperationDeclaration declaration, Query query) {
            ParameterDeclaration parameterDeclaration = declaration.getAllParameters().stream().filter(p -> p.getModelProperty(ImplementingParameterModelProperty.class).isPresent()).filter(p -> p.getModelProperty(ImplementingParameterModelProperty.class).get().getParameter().isAnnotationPresent(MetadataKeyId.class)).findFirst().orElseThrow(() -> new IllegalParameterModelDefinitionException("Query operation must have a parameter annotated with @MetadataKeyId"));
            parameterDeclaration.addModelProperty(new QueryParameterModelProperty(query.translator()));
            parameterDeclaration.setLayoutModel(LayoutModel.builderFrom(parameterDeclaration.getLayoutModel()).asQuery().build());
        }

        private MetadataResolverFactory getMetadataResolverFactory(MetadataScopeAdapter scope) {
            return scope.isCustomScope() ? new DefaultMetadataResolverFactory(scope.getKeysResolver(), scope.getInputResolvers(), scope.getOutputResolver(), scope.getAttributesResolver()) : new NullMetadataResolverFactory();
        }

        private void declareInputResolvers(ParameterizedDeclaration<?> declaration, MetadataScopeAdapter metadataScope) {
            if (metadataScope.hasInputResolvers()) {
                Set<String> dynamicParameters = metadataScope.getInputResolvers().keySet();
                declaration.getAllParameters().stream().filter(p -> dynamicParameters.contains(p.getName())).forEach(this::declareDynamicType);
            }
        }

        private void declareOutputResolvers(WithOutputDeclaration declaration, MetadataScopeAdapter metadataScope) {
            if (metadataScope.hasOutputResolver()) {
                this.declareDynamicType(declaration.getOutput());
            }
            if (metadataScope.hasAttributesResolver()) {
                this.declareDynamicType(declaration.getOutputAttributes());
            }
        }

        private void declareDynamicType(TypedDeclaration component) {
            component.setType(component.getType(), true);
        }

        private void declareMetadataKeyId(ComponentDeclaration<? extends ComponentDeclaration> component, String categoryName) {
            this.getMetadataKeyModelProperty(component, categoryName).ifPresent(component::addModelProperty);
        }

        private Optional<MetadataKeyIdModelProperty> getMetadataKeyModelProperty(ComponentDeclaration<? extends ComponentDeclaration> component, String categoryName) {
            Optional<MetadataKeyIdModelProperty> keyId = this.findMetadataKeyIdInGroups(component, categoryName);
            return keyId.isPresent() ? keyId : this.findMetadataKeyIdInParameters(component, categoryName);
        }

        private Optional<MetadataKeyIdModelProperty> findMetadataKeyIdInGroups(ComponentDeclaration<? extends ComponentDeclaration> component, String categoryName) {
            return component.getParameterGroups().stream().map(group -> group.getModelProperty(ParameterGroupModelProperty.class).orElse(null)).filter(Objects::nonNull).filter(group -> group.getDescriptor().getAnnotatedContainer().isAnnotatedWith(MetadataKeyId.class)).map(group -> new MetadataKeyIdModelProperty(group.getDescriptor().getMetadataType(), group.getDescriptor().getName(), categoryName)).findFirst();
        }

        private Optional<MetadataKeyIdModelProperty> findMetadataKeyIdInParameters(ComponentDeclaration<? extends ComponentDeclaration> component, String categoryName) {
            return component.getParameterGroups().stream().flatMap(g -> g.getParameters().stream()).filter(p -> this.getExtensionParameter((ParameterDeclaration)p).map(element -> element.isAnnotatedWith(MetadataKeyId.class)).orElse(false)).map(p -> new MetadataKeyIdModelProperty(p.getType(), p.getName(), categoryName)).findFirst();
        }

        private Optional<ExtensionParameter> getExtensionParameter(ParameterDeclaration parameterDeclaration) {
            return parameterDeclaration.getModelProperty(ExtensionParameterDescriptorModelProperty.class).map(ExtensionParameterDescriptorModelProperty::getExtensionParameter);
        }

        private void parseMetadataKeyAnnotations(ExtensionParameter element, BaseDeclaration baseDeclaration, TypeKeysResolver keysResolver) {
            element.getValueFromAnnotation(MetadataKeyId.class).ifPresent(valueFetcher -> {
                boolean hasKeyResolver = !(keysResolver instanceof NullMetadataResolver);
                baseDeclaration.addModelProperty(new MetadataKeyPartModelProperty(1, hasKeyResolver));
            });
            element.getValueFromAnnotation(MetadataKeyPart.class).ifPresent(valueFetcher -> baseDeclaration.addModelProperty(new MetadataKeyPartModelProperty(valueFetcher.getNumberValue(MetadataKeyPart::order), valueFetcher.getBooleanValue(MetadataKeyPart::providedByKeyResolver))));
        }

        private String getCategoryName(MetadataScopeAdapter metadataScopeAdapter) {
            NamedTypeResolver resolver = metadataScopeAdapter.getKeysResolver().get();
            if (resolver instanceof NullMetadataResolver) {
                resolver = metadataScopeAdapter.hasInputResolvers() ? (NamedTypeResolver)metadataScopeAdapter.getInputResolvers().values().iterator().next().get() : (NamedTypeResolver)metadataScopeAdapter.getOutputResolver().get();
            }
            return resolver instanceof NullMetadataResolver ? null : resolver.getCategoryName();
        }
    }
}

