/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.extension.api.client.ExtensionsClient;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.client.DefaultExtensionsClient;
import org.mule.runtime.module.extension.internal.runtime.client.strategy.ExtensionsClientProcessorsStrategyFactory;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;

public class ExtensionsClientArgumentResolver
implements ArgumentResolver<ExtensionsClient> {
    private final ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory;

    public ExtensionsClientArgumentResolver(ExtensionsClientProcessorsStrategyFactory extensionsClientProcessorsStrategyFactory) {
        this.extensionsClientProcessorsStrategyFactory = extensionsClientProcessorsStrategyFactory;
    }

    @Override
    public ExtensionsClient resolve(ExecutionContext executionContext) {
        ExecutionContextAdapter cxt = (ExecutionContextAdapter)executionContext;
        DefaultExtensionsClient extensionClient = new DefaultExtensionsClient(cxt.getEvent(), this.extensionsClientProcessorsStrategyFactory);
        try {
            extensionClient.initialise();
        }
        catch (InitialisationException e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failed to initialise Extension Client"), (Throwable)e);
        }
        return extensionClient;
    }
}

