/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import com.google.common.collect.ImmutableBiMap;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.mule.metadata.api.model.ArrayType;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.api.visitor.MetadataTypeVisitor;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.el.ExpressionManager;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;
import org.mule.runtime.module.extension.internal.loader.java.property.ParameterGroupModelProperty;
import org.mule.runtime.module.extension.internal.runtime.objectbuilder.DefaultObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.CollectionValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.MapValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ParametersResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.StaticValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;
import org.mule.runtime.module.extension.internal.runtime.resolver.resolver.ValueResolverFactory;
import org.mule.runtime.module.extension.internal.util.ReflectionCache;

public class ResolverSetUtils {
    public static ResolverSet getResolverSetFromStaticValues(ParameterizedModel parameterizedModel, Map<String, Object> parameters, MuleContext muleContext, boolean disableValidations, ReflectionCache reflectionCache, ExpressionManager expressionManager, String parametersOwner, DslSyntaxResolver dslSyntaxResolver) throws MuleException {
        HashMap<String, ValueResolver> resolvers = new HashMap<String, ValueResolver>();
        ValueResolverFactory valueResolverFactory = new ValueResolverFactory(dslSyntaxResolver);
        for (ParameterGroupModel parameterGroupModel : parameterizedModel.getParameterGroupModels()) {
            resolvers.putAll(ResolverSetUtils.getParameterGroupValueResolvers(parameterGroupModel, parameters, reflectionCache, muleContext, valueResolverFactory));
        }
        return ParametersResolver.fromValues(resolvers, muleContext, disableValidations, reflectionCache, expressionManager, parametersOwner).getParametersAsResolverSet(parameterizedModel, muleContext);
    }

    private static Map<String, ValueResolver> getParameterGroupValueResolvers(ParameterGroupModel parameterGroupModel, Map<String, Object> parameters, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional<Class<?>> parameterGroupDeclaringClass;
        Optional<ParameterGroupModelProperty> parameterGroupModelProperty;
        Map<String, ValueResolver> parameterGroupParametersValueResolvers = ResolverSetUtils.getParameterGroupParametersValueResolvers(parameterGroupModel, parameters, reflectionCache, muleContext, valueResolverFactory);
        if (parameterGroupModel.isShowInDsl() && !parameterGroupParametersValueResolvers.isEmpty() && (parameterGroupModelProperty = parameterGroupModel.getModelProperty(ParameterGroupModelProperty.class)).isPresent() && (parameterGroupDeclaringClass = parameterGroupModelProperty.get().getDescriptor().getType().getDeclaringClass()).isPresent()) {
            DefaultObjectBuilder defaultObjectBuilder = new DefaultObjectBuilder(parameterGroupDeclaringClass.get(), reflectionCache);
            for (Map.Entry<String, ValueResolver> stringValueResolverEntry : parameterGroupParametersValueResolvers.entrySet()) {
                defaultObjectBuilder.addPropertyResolver(stringValueResolverEntry.getKey(), (ValueResolver<Object>)stringValueResolverEntry.getValue());
            }
            ObjectBuilderValueResolver objectBuilderValuerResolver = new ObjectBuilderValueResolver(defaultObjectBuilder, muleContext);
            return ImmutableBiMap.of((Object)((Field)parameterGroupModelProperty.get().getDescriptor().getContainer()).getName(), objectBuilderValuerResolver);
        }
        return parameterGroupParametersValueResolvers;
    }

    private static Map<String, ValueResolver> getParameterGroupParametersValueResolvers(ParameterGroupModel parameterGroupModel, Map<String, Object> parameters, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        HashMap<String, ValueResolver> parameterGroupParametersValueResolvers = new HashMap<String, ValueResolver>();
        for (ParameterModel parameterModel : parameterGroupModel.getParameterModels()) {
            if (!parameters.containsKey(parameterModel.getName())) continue;
            parameterGroupParametersValueResolvers.put(parameterModel.getName(), ResolverSetUtils.getParameterValueResolver(parameterModel.getName(), parameterModel.getType(), parameters.get(parameterModel.getName()), parameterModel.getModelProperties(), reflectionCache, muleContext, valueResolverFactory));
        }
        return parameterGroupParametersValueResolvers;
    }

    private static ValueResolver getParameterValueResolver(final String parameterName, final MetadataType type, final Object value, final Set<ModelProperty> modelProperties, final ReflectionCache reflectionCache, final MuleContext muleContext, final ValueResolverFactory valueResolverFactory) throws MuleException {
        final Reference resolverReference = new Reference();
        type.accept(new MetadataTypeVisitor(){

            @Override
            public void visitArrayType(ArrayType arrayType) {
                if (value instanceof Collection) {
                    try {
                        resolverReference.set(ResolverSetUtils.getParameterValueResolverForCollection(parameterName, arrayType, (Collection)value, reflectionCache, muleContext, valueResolverFactory));
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException(e);
                    }
                } else {
                    this.defaultVisit(arrayType);
                }
            }

            @Override
            public void visitObject(ObjectType objectType) {
                if (ExtensionMetadataTypeUtils.isMap(objectType)) {
                    if (value instanceof Map) {
                        try {
                            resolverReference.set(ResolverSetUtils.getParameterValueResolverForMap(parameterName, objectType, (Map)value, reflectionCache, muleContext, valueResolverFactory));
                        }
                        catch (MuleException e) {
                            throw new MuleRuntimeException(e);
                        }
                    } else {
                        this.defaultVisit(objectType);
                    }
                } else {
                    try {
                        resolverReference.set(ResolverSetUtils.getPojoParameterValueResolver(parameterName, objectType, value, reflectionCache, muleContext, valueResolverFactory));
                    }
                    catch (MuleException e) {
                        throw new MuleRuntimeException(e);
                    }
                }
            }

            @Override
            protected void defaultVisit(MetadataType metadataType) {
                resolverReference.set(valueResolverFactory.of(parameterName, metadataType, value, MetadataTypeUtils.getDefaultValue(type), ExtensionMetadataTypeUtils.getExpressionSupport(metadataType), false, modelProperties));
            }
        });
        LifecycleUtils.initialiseIfNeeded(resolverReference.get(), muleContext);
        return (ValueResolver)resolverReference.get();
    }

    private static ValueResolver getPojoParameterValueResolver(String parameterName, ObjectType objectType, Object value, ReflectionCache reflectionCache, final MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional pojoClass = ExtensionMetadataTypeUtils.getType(objectType);
        if (pojoClass.isPresent() && value instanceof Map) {
            final DefaultObjectBuilder objectBuilder = new DefaultObjectBuilder(pojoClass.get(), reflectionCache);
            Iterator<ObjectFieldType> iterator = objectType.getFields().iterator();
            while (iterator.hasNext()) {
                Map valuesMap = (Map)value;
                ObjectFieldType objectFieldType = iterator.next();
                if (!valuesMap.containsKey(objectFieldType.getKey().getName().toString())) continue;
                objectBuilder.addPropertyResolver(objectFieldType.getKey().getName().toString(), (ValueResolver<Object>)ResolverSetUtils.getParameterValueResolver(parameterName, objectFieldType.getValue(), valuesMap.get(objectFieldType.getKey().getName().toString()), Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory));
            }
            LifecycleUtils.initialiseIfNeeded(objectBuilder, muleContext);
            return new ValueResolver(){

                public Object resolve(ValueResolvingContext context) throws MuleException {
                    Object result = objectBuilder.build(context);
                    muleContext.getInjector().inject(result);
                    return result;
                }

                @Override
                public boolean isDynamic() {
                    return objectBuilder.isDynamic();
                }
            };
        }
        return new StaticValueResolver<Object>(value);
    }

    private static ValueResolver getParameterValueResolverForCollection(String parameterName, ArrayType arrayType, Collection collection, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional expectedType = ExtensionMetadataTypeUtils.getType(arrayType);
        if (expectedType.isPresent()) {
            Class type = expectedType.get();
            ArrayList itemsResolvers = new ArrayList();
            for (Object collectionItem : collection) {
                itemsResolvers.add(ResolverSetUtils.getParameterValueResolver(parameterName, arrayType.getType(), collectionItem, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory));
            }
            return CollectionValueResolver.of(type, itemsResolvers);
        }
        return new StaticValueResolver<Collection>(collection);
    }

    private static ValueResolver getParameterValueResolverForMap(String parameterName, ObjectType type, Map<Object, Object> map, ReflectionCache reflectionCache, MuleContext muleContext, ValueResolverFactory valueResolverFactory) throws MuleException {
        Optional mapClassOptional = ExtensionMetadataTypeUtils.getType(type);
        Class mapClass = mapClassOptional.get();
        MetadataType valueType = type.getOpenRestriction().orElse(null);
        Function<Object, ValueResolver> valueValueResolverFunction = valueType != null ? value -> {
            try {
                return ResolverSetUtils.getParameterValueResolver(parameterName, valueType, value, Collections.emptySet(), reflectionCache, muleContext, valueResolverFactory);
            }
            catch (MuleException e) {
                throw new MuleRuntimeException(e);
            }
        } : value -> new StaticValueResolver<Object>(value);
        ArrayList keyResolvers = new ArrayList();
        ArrayList valueResolvers = new ArrayList();
        for (Map.Entry<Object, Object> mapEntry : map.entrySet()) {
            keyResolvers.add(new StaticValueResolver<String>(mapEntry.getKey().toString()));
            valueResolvers.add(valueValueResolverFunction.apply(mapEntry.getValue()));
        }
        return MapValueResolver.of(mapClass, keyResolvers, valueResolvers, reflectionCache, muleContext);
    }
}

