/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.source;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.mule.runtime.api.connection.ConnectionException;
import org.mule.runtime.api.connection.ConnectionHandler;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.connection.ConnectionValidationResult;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.core.api.connector.ConnectionManager;
import org.mule.runtime.extension.api.runtime.config.ConfigurationInstance;

public class SourceConnectionManager {
    private final ReentrantLock lock = new ReentrantLock();
    private final ConnectionManager connectionManager;
    private final Cache<Reference<Object>, Pair<AtomicInteger, ConnectionHandler<Object>>> connections = Caffeine.newBuilder().build();

    SourceConnectionManager(ConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    <T> T getConnection(ConfigurationInstance config) throws ConnectionException {
        ConnectionHandler connectionHandler = this.connectionManager.getConnection(config.getValue());
        Object connection = connectionHandler.getConnection();
        Reference connReference = new Reference(connection);
        this.lock.lock();
        try {
            ((AtomicInteger)((Pair)this.connections.get(connReference, k -> new Pair<AtomicInteger, ConnectionHandler>(new AtomicInteger(0), connectionHandler))).getFirst()).incrementAndGet();
        }
        finally {
            this.lock.unlock();
        }
        return (T)connection;
    }

    void release(Object connection) {
        this.decreaseConnectionReferenceCount(new Reference<Object>(connection), connHandler -> {
            if (connHandler != null) {
                connHandler.release();
            }
        });
    }

    void invalidate(Object connection) {
        this.decreaseConnectionReferenceCount(new Reference<Object>(connection), connHandler -> {
            if (connHandler != null) {
                connHandler.invalidate();
            }
        });
    }

    ConnectionValidationResult testConnectivity(Object connection) {
        Pair connPair = (Pair)this.connections.getIfPresent(new Reference<Object>(connection));
        if (connPair == null || connPair.getSecond() == null) {
            throw new IllegalArgumentException("Cannot validate a connection which was not generated through this " + ConnectionProvider.class.getSimpleName());
        }
        return this.connectionManager.testConnectivity(connection, (ConnectionHandler)connPair.getSecond());
    }

    <T> Optional<ConnectionHandler<T>> getConnectionHandler(T connection) {
        return Optional.ofNullable(this.connections.getIfPresent(new Reference<T>(connection))).map(c -> (ConnectionHandler)c.getSecond());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decreaseConnectionReferenceCount(Reference<Object> connReference, Consumer<ConnectionHandler<Object>> consumer) {
        this.lock.lock();
        try {
            Pair connPair = (Pair)this.connections.getIfPresent(connReference);
            if (connPair == null || ((AtomicInteger)connPair.getFirst()).decrementAndGet() > 0) {
                return;
            }
            consumer.accept((ConnectionHandler<Object>)connPair.getSecond());
            this.connections.invalidate(connReference);
        }
        finally {
            this.lock.unlock();
        }
    }
}

