/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.dsl.internal.xerces.xni.parser;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.mule.apache.xerces.util.XMLResourceIdentifierImpl;
import org.mule.apache.xerces.xni.XMLResourceIdentifier;
import org.mule.apache.xerces.xni.XNIException;
import org.mule.apache.xerces.xni.parser.XMLEntityResolver;
import org.mule.apache.xerces.xni.parser.XMLInputSource;
import org.mule.runtime.dsl.internal.util.SchemaMappingsUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultXmlEntityResolver
implements XMLEntityResolver {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultXmlEntityResolver.class);
    private final Map<String, String> schemas = SchemaMappingsUtils.getMuleSchemasMappings();

    @Override
    public XMLInputSource resolveEntity(XMLResourceIdentifier resourceIdentifier) throws XNIException, IOException {
        String publicId = resourceIdentifier.getPublicId();
        String systemId = resourceIdentifier.getExpandedSystemId();
        if (publicId == null && systemId == null) {
            return null;
        }
        systemId = SchemaMappingsUtils.resolveSystemId(systemId);
        return this.resolveEntity(this.schemas, publicId, systemId);
    }

    private XMLInputSource resolveEntity(Map<String, String> schemas, String publicId, String systemId) {
        String resourceLocation = schemas.get(systemId);
        if (resourceLocation != null) {
            URL resource = DefaultXmlEntityResolver.class.getClassLoader().getResource(resourceLocation);
            if (resource == null) {
                LOGGER.debug("Couldn't find schema [" + systemId + "]: " + resourceLocation);
            } else {
                try {
                    URLConnection connection = resource.openConnection();
                    connection.setUseCaches(false);
                    InputStream is = connection.getInputStream();
                    XMLResourceIdentifierImpl resourceIdentifier = new XMLResourceIdentifierImpl();
                    resourceIdentifier.setPublicId(publicId);
                    resourceIdentifier.setLiteralSystemId(systemId);
                    resourceIdentifier.setBaseSystemId(null);
                    XMLInputSource source = new XMLInputSource(resourceIdentifier);
                    source.setByteStream(is);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Found XML schema [" + systemId + "] in classpath: " + resourceLocation);
                    }
                    return source;
                }
                catch (IOException e) {
                    LOGGER.warn("Error loading XSD [" + systemId + "]: " + resourceLocation, (Throwable)e);
                }
            }
        }
        return null;
    }
}

