/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.config;

import java.util.Optional;
import org.mule.runtime.api.config.Feature;

public enum MuleRuntimeFeature implements Feature
{
    HONOUR_RESERVED_PROPERTIES("Whether reserved properties such as 'app.name' can't be overridden by global properties.", "MULE-19038", "4.4.0, 4.3.1", "mule.honour.reserved.properties"),
    HANDLE_SPLITTER_EXCEPTION("If set to true, then DW will correctly handle Splitter's exceptions, avoiding some serialization issues.", "DW-383", "4.4.0, 4.3.1, 4.2.3", "mule.dw.handle_splitter_exception"),
    BATCH_FIXED_AGGREGATOR_TRANSACTION_RECORD_BUFFER("If set to true, then fixed batch aggregator will only commit when a full block is processed.", "EE-7443", "4.4.0, 4.3.1, 4.2.3", "mule.batch.fixed.aggregator.transaction.record.buffer"),
    COMPUTE_CONNECTION_ERRORS_IN_STATS("If set to true, the connection errors will be computed to trigger alerts.", "DW-383", "4.4.0, 4.3.1", "mule.compute.connection.errors.in.stats"),
    TO_STRING_TRANSFORMER_TRANSFORM_ITERATOR_ELEMENTS("If set to true, managed iterators transformed to Strings will show the representation of the elements instead of the generic 'org.mule.runtime.core.internal.streaming.object.ManagedCursorIteratorProvider$ManagedCursorIterator@######'.", "MULE-19323", "4.4.0", "mule.transformer.toString.transformIteratorElements"),
    ENABLE_POLICY_ISOLATION("If set to true, extensions imported by a policy will be managed in complete isolation from the extensions imported by the application that is being applied to, and validations will prevent the usage of explicit configurations declared by the application as part of the policy initialization.", "MULE-19226", "4.4.0, 4.3.1", "mule.enable.policy.isolation"),
    ENTITY_RESOLVER_FAIL_ON_FIRST_ERROR("If set to true, the Mule XML DSL parser will fail when deploying an application that declares a schema that cannot be located. If set to false, it will only fail if such application makes use of the namespace that such schema defines, instead of just declaring it.", "EE-7827", "4.4.0", "mule.entityResolver.failOnFirstError"),
    ENABLE_PROFILING_SERVICE("If set to true, profiling events will be produced", "MULE-19588", "4.5.0", "mule.enable.profiling.service"),
    SET_VARIABLE_WITH_NULL_VALUE("If set to true, the set variable will create a variable even if the value is null", "MULE-19443", "4.4.0", "mule.setVariable.WithNullValue");

    private final String description;
    private final String issueId;
    private final String since;
    private final String overridingSystemPropertyName;

    private MuleRuntimeFeature(String description, String issue, String since) {
        this(description, issue, since, null);
    }

    private MuleRuntimeFeature(String description, String issueId, String since, String overridingSystemPropertyName) {
        this.description = description;
        this.issueId = issueId;
        this.since = since;
        this.overridingSystemPropertyName = overridingSystemPropertyName;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getIssueId() {
        return this.issueId;
    }

    @Override
    public String getSince() {
        return this.since;
    }

    @Override
    public Optional<String> getOverridingSystemPropertyName() {
        return Optional.ofNullable(this.overridingSystemPropertyName);
    }
}

