/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph.api;

import java.util.Set;
import org.mule.runtime.api.meta.model.stereotype.HasStereotypeModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ComponentAst;

public class ComponentAstDependency {
    private final String name;
    private final Set<StereotypeModel> allowedStereotypes;

    public ComponentAstDependency(String name, Set<StereotypeModel> allowedStereotypes) {
        this.name = name;
        this.allowedStereotypes = allowedStereotypes;
    }

    public String getName() {
        return this.name;
    }

    public Set<StereotypeModel> getAllowedStereotypes() {
        return this.allowedStereotypes;
    }

    public boolean isSatisfiedBy(ComponentAst component) {
        return component.getModel(HasStereotypeModel.class).filter(componentModel -> component.getComponentId().map(this.name::equals).orElse(false)).map(componentModel -> this.allowedStereotypes.stream().anyMatch(s -> componentModel.getStereotype() != null && componentModel.getStereotype().isAssignableTo((StereotypeModel)s))).orElse(false);
    }

    public String toString() {
        return String.format("'%s' (%s)", this.getName(), this.getAllowedStereotypes().toString());
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.allowedStereotypes == null ? 0 : this.allowedStereotypes.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ComponentAstDependency other = (ComponentAstDependency)obj;
        if (this.allowedStereotypes == null ? other.allowedStereotypes != null : !this.allowedStereotypes.equals(other.allowedStereotypes)) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

