/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.model;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.metadata.java.api.JavaTypeLoader;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ComponentModel;
import org.mule.runtime.api.meta.model.ComponentModelVisitor;
import org.mule.runtime.api.meta.model.ComposableModel;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.connection.ConnectionProviderModel;
import org.mule.runtime.api.meta.model.construct.ConstructModel;
import org.mule.runtime.api.meta.model.nested.NestableElementModel;
import org.mule.runtime.api.meta.model.nested.NestedChainModel;
import org.mule.runtime.api.meta.model.nested.NestedComponentModel;
import org.mule.runtime.api.meta.model.nested.NestedRouteModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.source.SourceModel;
import org.mule.runtime.api.meta.model.util.IdempotentExtensionWalker;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.api.util.Reference;
import org.mule.runtime.extension.api.declaration.type.ExtensionsTypeHandlerManagerFactory;
import org.mule.runtime.extension.api.dsl.syntax.DslElementSyntax;
import org.mule.runtime.extension.api.dsl.syntax.resolver.DslSyntaxResolver;
import org.mule.runtime.extension.api.stereotype.MuleStereotypes;
import org.mule.runtime.extension.api.util.ExtensionMetadataTypeUtils;

public class ExtensionModelHelper {
    private static final String ON_ERROR_MODEL = "onError";
    private static final String ON_ERROR_CONTINUE_MODEL = "onErrorContinue";
    private static final String ON_ERROR_PROPAGATE_MODEL = "onErrorPropagate";
    private static final String ON_ERROR_CONTINUE = "on-error-continue";
    private static final String ON_ERROR_PROPAGATE = "on-error-propagate";
    public static final ComponentIdentifier ON_ERROR_CONTINUE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-continue").build();
    public static final ComponentIdentifier ON_ERROR_PROPAGATE_IDENTIFIER = ComponentIdentifier.builder().namespace("mule").name("on-error-propagate").build();
    private final Set<ExtensionModel> extensionsModels;
    private final Cache<ComponentIdentifier, Optional<ComponentModel>> extensionComponentModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<ConnectionProviderModel>> extensionConnectionProviderModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Cache<ComponentIdentifier, Optional<ConfigurationModel>> extensionConfigurationModelByComponentIdentifier = Caffeine.newBuilder().build();
    private final Optional<DslSyntaxResolver> muleTopLevelDslSyntaxResolver;
    private final LoadingCache<ExtensionModel, DslSyntaxResolver> dslSyntaxResolversByExtension;
    private final JavaTypeLoader javaTypeLoader = new JavaTypeLoader(ExtensionModelHelper.class.getClassLoader(), new ExtensionsTypeHandlerManagerFactory());
    private final DslResolvingContext dslResolvingContext;

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels) {
        this(extensionModels, DslResolvingContext.getDefault(extensionModels));
    }

    public ExtensionModelHelper(Set<ExtensionModel> extensionModels, DslResolvingContext dslResolvingCtx) {
        this.extensionsModels = extensionModels;
        this.muleTopLevelDslSyntaxResolver = extensionModels.stream().filter(extModel -> extModel.getName().equals("mule")).map(extModel -> DslSyntaxResolver.getDefault(extModel, dslResolvingCtx)).findAny();
        this.dslSyntaxResolversByExtension = Caffeine.newBuilder().build(key -> DslSyntaxResolver.getDefault(key, dslResolvingCtx));
        this.dslResolvingContext = dslResolvingCtx;
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentIdentifier componentIdentifier) {
        return this.findComponentModel(componentIdentifier).map(this::findComponentType).orElse(TypedComponentIdentifier.ComponentType.UNKNOWN);
    }

    public TypedComponentIdentifier.ComponentType findComponentType(ComponentModel extensionComponentModel) {
        final Reference componentTypeReference = new Reference();
        extensionComponentModel.accept(new ComponentModelVisitor(){

            @Override
            public void visit(OperationModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.OPERATION);
                this.determineFromNested(componentTypeReference, model);
            }

            @Override
            public void visit(SourceModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.SOURCE);
            }

            @Override
            public void visit(ConstructModel model) {
                if (model.getStereotype().equals(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                    return;
                }
                if (model.getStereotype().equals(MuleStereotypes.ON_ERROR)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ON_ERROR);
                    return;
                }
                if (model.getStereotype().equals(MuleStereotypes.FLOW)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.FLOW);
                    return;
                }
                if (model.getStereotype().equals(MuleStereotypes.CHAIN)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.CHAIN);
                    return;
                }
                this.determineFromNested(componentTypeReference, model);
            }

            protected void determineFromNested(Reference<TypedComponentIdentifier.ComponentType> componentTypeReference2, ComposableModel model) {
                NestedComponentVisitor nestedComponentVisitor = new NestedComponentVisitor(componentTypeReference2);
                for (NestableElementModel nestableElementModel : model.getNestedComponents()) {
                    nestableElementModel.accept(nestedComponentVisitor);
                    if (componentTypeReference2.get() == null) continue;
                    return;
                }
            }

            @Override
            public void visit(NestedComponentModel model) {
                if (model.getAllowedStereotypes().contains(MuleStereotypes.ERROR_HANDLER)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ERROR_HANDLER);
                    return;
                }
                if (model.getAllowedStereotypes().contains(MuleStereotypes.ON_ERROR)) {
                    componentTypeReference.set(TypedComponentIdentifier.ComponentType.ON_ERROR);
                    return;
                }
            }

            @Override
            public void visit(NestedChainModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.CHAIN);
            }

            @Override
            public void visit(NestedRouteModel model) {
                componentTypeReference.set(TypedComponentIdentifier.ComponentType.ROUTE);
            }
        });
        return componentTypeReference.get() == null ? TypedComponentIdentifier.ComponentType.UNKNOWN : (TypedComponentIdentifier.ComponentType)((Object)componentTypeReference.get());
    }

    public Optional<ComponentModel> findComponentModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionComponentModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(extensionModel -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)extensionModel, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$extensionModel;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$extensionModel = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$extensionModel);
                }

                @Override
                protected void onOperation(OperationModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                @Override
                protected void onSource(SourceModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                @Override
                protected void onConstruct(ConstructModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                @Override
                protected void onNestable(NestableElementModel model) {
                    this.onModel(this.val$componentIdentifier, this.val$modelRef, model);
                }

                protected void onModel(ComponentIdentifier componentIdentifier, AtomicReference<ComponentModel> modelRef, ComponentModel model) {
                    if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                        modelRef.set(model);
                    }
                }
            }.walk((ExtensionModel)extensionModel);
            return Optional.ofNullable(modelRef.get());
        }));
    }

    public Optional<ConnectionProviderModel> findConnectionProviderModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConnectionProviderModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
                }

                @Override
                protected void onConnectionProvider(ConnectionProviderModel model) {
                    if (this.dslSyntaxResolver.resolve(model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk((ExtensionModel)currentExtension);
            return Optional.ofNullable(modelRef.get());
        }));
    }

    public Optional<ConfigurationModel> findConfigurationModel(ComponentIdentifier componentId) {
        return (Optional)this.extensionConfigurationModelByComponentIdentifier.get((Object)componentId, componentIdentifier -> this.lookupExtensionModelFor((ComponentIdentifier)componentIdentifier).flatMap(currentExtension -> {
            AtomicReference modelRef = new AtomicReference();
            new IdempotentExtensionWalker((ExtensionModel)currentExtension, (ComponentIdentifier)componentIdentifier, modelRef){
                final DslSyntaxResolver dslSyntaxResolver;
                final /* synthetic */ ExtensionModel val$currentExtension;
                final /* synthetic */ ComponentIdentifier val$componentIdentifier;
                final /* synthetic */ AtomicReference val$modelRef;
                {
                    this.val$currentExtension = extensionModel;
                    this.val$componentIdentifier = componentIdentifier;
                    this.val$modelRef = atomicReference;
                    this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)this.val$currentExtension);
                }

                @Override
                protected void onConfiguration(ConfigurationModel model) {
                    if (this.dslSyntaxResolver.resolve(model).getElementName().equals(this.val$componentIdentifier.getName())) {
                        this.val$modelRef.set(model);
                    }
                }
            }.walk((ExtensionModel)currentExtension);
            return Optional.ofNullable(modelRef.get());
        }));
    }

    public Optional<ParameterModel> findParameterModel(ComponentIdentifier nestedComponentId, ParameterizedModel model) {
        return this.lookupExtensionModelFor(nestedComponentId).flatMap(currentExtension -> {
            DslSyntaxResolver dslSyntaxResolver = (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get(currentExtension);
            return model.getAllParameterModels().stream().filter(pm -> dslSyntaxResolver.resolve((ParameterModel)pm).getElementName().equals(nestedComponentId.getName())).findAny();
        });
    }

    public void walkToComponent(final ComponentIdentifier componentIdentifier, final boolean topLevel, final ExtensionWalkerModelDelegate delegate, final ExtensionModel currentExtension) {
        new IdempotentExtensionWalker(){
            final DslSyntaxResolver dslSyntaxResolver;
            final List<ConstructModel> overriders;
            {
                this.dslSyntaxResolver = (DslSyntaxResolver)ExtensionModelHelper.this.dslSyntaxResolversByExtension.get((Object)currentExtension);
                this.overriders = currentExtension.getConstructModels();
            }

            @Override
            protected void onConfiguration(ConfigurationModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConfiguration(model);
                    this.stop();
                }
            }

            @Override
            protected void onConnectionProvider(ConnectionProviderModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConnectionProvider(model);
                    this.stop();
                }
            }

            @Override
            protected void onOperation(OperationModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onOperation(model);
                    this.stop();
                }
            }

            @Override
            protected void onSource(SourceModel model) {
                if (this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    delegate.onSource(model);
                    this.stop();
                }
            }

            @Override
            protected void onConstruct(ConstructModel model) {
                DslElementSyntax dslSyntax = ExtensionModelHelper.this.muleTopLevelDslSyntaxResolver.map(resolver -> resolver.resolve(model)).orElseGet(() -> this.dslSyntaxResolver.resolve(model));
                if (dslSyntax.getElementName().equals(componentIdentifier.getName())) {
                    delegate.onConstruct(model);
                    this.stop();
                }
            }

            private Optional<ConstructModel> findOnErrorOverrider(NestableElementModel model) {
                if (!ExtensionModelHelper.ON_ERROR_MODEL.equals(model.getName())) {
                    return Optional.empty();
                }
                return this.overriders.stream().filter(e -> e.getName().equals(model.getName())).findFirst();
            }

            @Override
            protected void onNestable(ComposableModel owner, NestableElementModel model) {
                if (!topLevel && this.dslSyntaxResolver.resolve(model).getElementName().equals(componentIdentifier.getName())) {
                    Optional<ConstructModel> overrider = this.findOnErrorOverrider(model);
                    if (overrider.isPresent()) {
                        delegate.onConstruct(overrider.get());
                    } else {
                        if (this.shouldSkipNestable(model, currentExtension)) {
                            return;
                        }
                        delegate.onNestableElement(model);
                    }
                    this.stop();
                }
            }

            private boolean shouldSkipNestable(NestableElementModel model, ExtensionModel currentExtension2) {
                if (ExtensionModelHelper.ON_ERROR_PROPAGATE_MODEL.equals(model.getName())) {
                    return false;
                }
                if (ExtensionModelHelper.ON_ERROR_CONTINUE_MODEL.equals(model.getName())) {
                    return false;
                }
                return currentExtension2.getConstructModel(model.getName()).isPresent();
            }

            @Override
            protected void onType(MetadataType type) {
                ExtensionModelHelper.this.resolveDslElementModel(type, currentExtension).filter(dsl -> ComponentIdentifier.builder().name(dsl.getElementName()).namespace(dsl.getPrefix()).build().equals(componentIdentifier)).ifPresent(dsl -> {
                    if (ExtensionModelHelper.this.walkableType(type, dsl)) {
                        delegate.onType(type);
                    }
                    this.stop();
                });
            }
        }.walk(currentExtension);
    }

    private boolean walkableType(MetadataType type, DslElementSyntax dsl) {
        return dsl.supportsTopLevelDeclaration() || dsl.supportsChildDeclaration() && dsl.isWrapped() || ExtensionMetadataTypeUtils.getSubstitutionGroup(type).isPresent() || this.getAllSubTypes().contains(type);
    }

    public Optional<MetadataType> findMetadataType(Class<?> type) {
        if (type != null) {
            return Optional.of(this.javaTypeLoader.load(type));
        }
        return Optional.empty();
    }

    public Optional<ExtensionModel> lookupExtensionModelFor(ComponentIdentifier componentIdentifier) {
        return this.lookupExtensionModelFor(componentIdentifier.getNamespace());
    }

    private Optional<ExtensionModel> lookupExtensionModelFor(String namespacePrefix) {
        return this.extensionsModels.stream().filter(e -> e.getXmlDslModel().getPrefix().equals(namespacePrefix.equals("tls") ? "mule" : namespacePrefix)).findFirst();
    }

    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType type, String namespacePrefix) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(namespacePrefix);
        return dslSyntaxResolver.resolve(type);
    }

    public DslElementSyntax resolveDslElementModel(NamedObject component, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(component);
    }

    private DslSyntaxResolver getDslSyntaxResolver(ComponentIdentifier componentIdentifier) {
        Optional<ExtensionModel> optionalExtensionModel = this.lookupExtensionModelFor(componentIdentifier);
        ExtensionModel extensionModel = optionalExtensionModel.orElseThrow(() -> new IllegalStateException("Extension Model in context not present for componentIdentifier: " + componentIdentifier));
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel);
    }

    private DslSyntaxResolver getDslSyntaxResolver(String namespacePrefix) {
        Optional<ExtensionModel> optionalExtensionModel = this.lookupExtensionModelFor(namespacePrefix);
        ExtensionModel extensionModel = optionalExtensionModel.orElseThrow(() -> new IllegalStateException("Extension Model in context not present for namespace: " + namespacePrefix));
        return (DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel);
    }

    public Optional<DslElementSyntax> resolveDslElementModel(MetadataType metadataType, ExtensionModel extensionModel) {
        return ((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get((Object)extensionModel)).resolve(metadataType);
    }

    public DslElementSyntax resolveDslElementModel(ParameterModel parameterModel, ComponentIdentifier componentIdentifier) {
        DslSyntaxResolver dslSyntaxResolver = this.getDslSyntaxResolver(componentIdentifier);
        return dslSyntaxResolver.resolve(parameterModel);
    }

    public Map<ObjectType, Optional<DslElementSyntax>> resolveSubTypes(ObjectType type) {
        HashMap singletonizedSubTypes = new HashMap();
        MetadataTypeUtils.getTypeId(type).ifPresent(typeId -> this.dslResolvingContext.getTypeCatalog().getDeclaringExtension((String)typeId).flatMap(this.dslResolvingContext::getExtension).ifPresent(declaringExtension -> singletonizedSubTypes.putIfAbsent(new Pair<ExtensionModel, String>((ExtensionModel)declaringExtension, (String)typeId), type)));
        for (ObjectType subType : this.dslResolvingContext.getTypeCatalog().getSubTypes(type)) {
            MetadataTypeUtils.getTypeId(subType).ifPresent(subTypeId -> this.dslResolvingContext.getTypeCatalog().getDeclaringExtension((String)subTypeId).flatMap(this.dslResolvingContext::getExtension).ifPresent(declaringExtension -> singletonizedSubTypes.putIfAbsent(new Pair<ExtensionModel, String>((ExtensionModel)declaringExtension, (String)subTypeId), subType)));
        }
        return singletonizedSubTypes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, e -> ((DslSyntaxResolver)this.dslSyntaxResolversByExtension.get(((Pair)e.getKey()).getFirst())).resolve((MetadataType)e.getValue())));
    }

    private Collection<ObjectType> getAllSubTypes() {
        return this.dslResolvingContext.getTypeCatalog().getAllSubTypes();
    }

    public Set<ExtensionModel> getExtensionsModels() {
        return this.extensionsModels;
    }

    static class NestedComponentVisitor
    implements ComponentModelVisitor {
        private final Reference<TypedComponentIdentifier.ComponentType> reference;

        public NestedComponentVisitor(Reference<TypedComponentIdentifier.ComponentType> reference) {
            this.reference = reference;
        }

        @Override
        public void visit(NestedChainModel component) {
            this.reference.set(TypedComponentIdentifier.ComponentType.SCOPE);
        }

        @Override
        public void visit(NestedRouteModel component) {
            this.reference.set(TypedComponentIdentifier.ComponentType.ROUTER);
        }

        @Override
        public void visit(NestedComponentModel component) {
        }

        @Override
        public void visit(OperationModel model) {
        }

        @Override
        public void visit(SourceModel model) {
        }

        @Override
        public void visit(ConstructModel model) {
        }
    }

    public static interface ExtensionWalkerModelDelegate {
        public void onConfiguration(ConfigurationModel var1);

        public void onConnectionProvider(ConnectionProviderModel var1);

        public void onOperation(OperationModel var1);

        public void onSource(SourceModel var1);

        public void onConstruct(ConstructModel var1);

        public void onNestableElement(NestableElementModel var1);

        public void onType(MetadataType var1);
    }
}

