/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.xml.reader;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.builder.ArtifactAstBuilder;
import org.mule.runtime.ast.api.builder.ComponentAstBuilder;
import org.mule.runtime.ast.api.builder.NamespaceDefinitionBuilder;
import org.mule.runtime.ast.api.xml.AstXmlParser;
import org.mule.runtime.ast.internal.DefaultComponentMetadataAst;
import org.mule.runtime.ast.internal.builder.ImportedResourceBuilder;
import org.mule.runtime.dsl.api.xml.parser.XmlApplicationParser;
import org.mule.runtime.dsl.internal.xml.parser.XmlMetadataAnnotations;
import org.mule.runtime.internal.dsl.DslConstants;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ComponentAstReader {
    private static final QName DECLARED_PREFIX_QNAME = QName.valueOf("DECLARED_PREFIX");
    private static final String SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String MODULE_PREFIX_ATTRIBUTE = "prefix";
    private static final String MODULE_NAMESPACE_ATTRIBUTE = "namespace";

    public void extractComponentDefinitionModel(XmlApplicationParser parser, Element element, String configFileName, ComponentAstBuilder componentAstBuilder) {
        componentAstBuilder.withIdentifier(this.buildIdentifier(parser, element));
        DefaultComponentMetadataAst.Builder metadata = this.extractMetadata(element, configFileName);
        this.processAttributes(componentAstBuilder, element);
        this.processAnnotations(componentAstBuilder, element);
        this.processChildNodesRecursively(componentAstBuilder, metadata, parser, element, configFileName);
        componentAstBuilder.withMetadata(metadata.build());
    }

    private ComponentIdentifier buildIdentifier(XmlApplicationParser parser, Element element) {
        String namespace = parser.parseNamespace(element);
        String namespaceUri = parser.parseNamespaceUri(element);
        ComponentIdentifier identifier = ComponentIdentifier.builder().namespace(namespace == null ? "mule" : namespace).namespaceUri(namespaceUri == null ? DslConstants.CORE_NAMESPACE : namespaceUri).name(parser.parseIdentifier(element)).build();
        return identifier;
    }

    private DefaultComponentMetadataAst.Builder extractMetadata(Element element, String configFileName) {
        Node nameAttribute;
        DefaultComponentMetadataAst.Builder metadataBuilder = DefaultComponentMetadataAst.builder().setFileName(configFileName);
        XmlMetadataAnnotations userData = (XmlMetadataAnnotations)element.getUserData("metadataAnnotations");
        if (userData != null) {
            metadataBuilder = metadataBuilder.setStartLine(userData.getLineNumber()).setEndLine(userData.getLineNumber()).setStartColumn(userData.getColumnNumber()).setEndColumn(userData.getColumnNumber()).setSourceCode(userData.getElementString());
        }
        if ((nameAttribute = element.getAttributes().getNamedItemNS(Component.Annotations.NAME_ANNOTATION_KEY.getNamespaceURI(), Component.Annotations.NAME_ANNOTATION_KEY.getLocalPart())) != null) {
            this.addCustomAttribute(metadataBuilder, Component.Annotations.NAME_ANNOTATION_KEY, nameAttribute.getNodeValue());
        }
        if (element.getPrefix() != null) {
            this.addCustomAttribute(metadataBuilder, DECLARED_PREFIX_QNAME, element.getPrefix());
        }
        for (int i = 0; i < element.getAttributes().getLength(); ++i) {
            Node attributeNode = element.getAttributes().item(i);
            if (attributeNode.getNamespaceURI() == null) continue;
            this.addCustomAttribute(metadataBuilder, new QName(attributeNode.getNamespaceURI(), attributeNode.getLocalName()), attributeNode.getNodeValue());
        }
        return metadataBuilder;
    }

    private void processAttributes(ComponentAstBuilder componentAstBuilder, Element element) {
        this.processAttributes(element, n -> StringUtils.isEmpty((CharSequence)n.getNamespaceURI()), node -> componentAstBuilder.withRawParameter(node.getNodeName(), node.getNodeValue()));
    }

    private void processAnnotations(ComponentAstBuilder componentAstBuilder, Element element) {
        this.processAttributes(element, n -> !StringUtils.isEmpty((CharSequence)n.getNamespaceURI()), node -> componentAstBuilder.withAnnotation(new QName(node.getNamespaceURI(), node.getLocalName()).toString(), node.getNodeValue()));
    }

    private Map<String, String> calculateSchemaLocations(String schLoc) {
        HashMap<String, String> schemaLocations = new HashMap<String, String>();
        String[] pairs = schLoc.trim().split("\\s+");
        for (int i = 0; i < pairs.length; i += 2) {
            schemaLocations.put(pairs[i], pairs[i + 1]);
        }
        return schemaLocations;
    }

    public void processAttributes(ArtifactAstBuilder astBuilder, Element element) {
        NamespaceDefinitionBuilder namespaceDefinitionBuilder = NamespaceDefinitionBuilder.builder();
        this.processAttributes(element, n -> true, node -> {
            String name = node.getNodeName();
            String value = node.getNodeValue();
            if (name.equals(SCHEMA_LOCATION)) {
                this.calculateSchemaLocations(value).forEach((schLoc, loc) -> namespaceDefinitionBuilder.withSchemaLocation((String)schLoc, (String)loc));
            } else if (name.equals(MODULE_NAMESPACE_ATTRIBUTE)) {
                namespaceDefinitionBuilder.withNamespace(value);
            } else if (name.equals(MODULE_PREFIX_ATTRIBUTE)) {
                namespaceDefinitionBuilder.withPrefix(value);
            } else {
                namespaceDefinitionBuilder.withUnresolvedNamespace(name, value);
            }
        });
        astBuilder.withNamespaceDefinition(namespaceDefinitionBuilder.build());
    }

    private void processAttributes(Element element, Predicate<Node> filter, Consumer<Node> consumer) {
        NamedNodeMap attributes = element.getAttributes();
        if (element.hasAttributes()) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attribute = attributes.item(i);
                if (!filter.test(attribute)) continue;
                consumer.accept(attribute);
            }
        }
    }

    private void processChildNodesRecursively(ComponentAstBuilder componentAstBuilder, DefaultComponentMetadataAst.Builder metadata, XmlApplicationParser parser, Element element, String configFileName) {
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (XmlApplicationParser.isTextContent(child)) {
                    componentAstBuilder.withBodyParameter(child.getNodeValue());
                    if (child.getNodeType() != 4) continue;
                    DefaultComponentMetadataAst.Builder metadataBuilder = metadata;
                    metadataBuilder.putParserAttribute("IS_CDATA", Boolean.TRUE);
                    break;
                }
                if (!(child instanceof Element)) continue;
                if (child.getNamespaceURI().equals(DslConstants.CORE_NAMESPACE) && child.getLocalName().endsWith(AstXmlParser.ANNOTATIONS_IDENTIFIER.getName())) {
                    this.processNestedAnnotations((Element)child, metadata);
                    continue;
                }
                this.extractComponentDefinitionModel(parser, (Element)child, configFileName, componentAstBuilder.addChildComponent());
            }
        }
    }

    private void processNestedAnnotations(Element element, DefaultComponentMetadataAst.Builder metadata) {
        if (element.hasChildNodes()) {
            NodeList children = element.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (!(child instanceof Element)) continue;
                this.addCustomAttribute(metadata, new QName(child.getNamespaceURI(), child.getLocalName(), child.getPrefix()), child.getTextContent().trim());
            }
        }
    }

    private void addCustomAttribute(DefaultComponentMetadataAst.Builder metadataBuilder, QName qname, Object value) {
        if (StringUtils.isEmpty((CharSequence)qname.getNamespaceURI()) || "http://www.mulesoft.org/schema/mule/parser-metadata".equals(qname.getNamespaceURI())) {
            metadataBuilder.putParserAttribute(qname.getLocalPart(), value);
        } else if ("http://www.mulesoft.org/schema/mule/documentation".equals(qname.getNamespaceURI())) {
            metadataBuilder.putDocAttribute(qname.getLocalPart(), value.toString());
        }
    }

    public void extractImport(ArtifactAstBuilder astBuilder, Element importNode, String configFileName) {
        ComponentMetadataAst metadata = this.extractMetadata(importNode, configFileName).build();
        if (!importNode.hasAttribute("file")) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("<import> does not have a file attribute defined. At file '%s', at line %s", metadata.getFileName(), metadata.getStartLine())));
        }
        astBuilder.withImportedResource(ImportedResourceBuilder.builder().withResourceLocation(importNode.getAttribute("file")).withMetadata(metadata).build());
    }
}

