/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.config;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessage;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Pair;

public class PropertyNotFoundException
extends MuleRuntimeException {
    private static final long serialVersionUID = -3570854244058568638L;
    private final List<Pair<String, String>> unresolvedKeys;

    public PropertyNotFoundException(Pair<String, String> resolverKeyPair) {
        super(PropertyNotFoundException.createFailureException(resolverKeyPair));
        this.unresolvedKeys = Collections.singletonList(resolverKeyPair);
    }

    private static I18nMessage createFailureException(Pair<String, String> resolverKeyPair) {
        return I18nMessageFactory.createStaticMessage(PropertyNotFoundException.createMessageForLeakKey(resolverKeyPair));
    }

    private static String createMessageForLeakKey(Pair<String, String> resolverKeyPair) {
        return String.format("Couldn't find configuration property value for key %s from properties provider %s", "${" + resolverKeyPair.getSecond() + "}", resolverKeyPair.getFirst());
    }

    public PropertyNotFoundException(PropertyNotFoundException propertyNotFoundException, Pair<String, String> resolverKeyPair) {
        super(PropertyNotFoundException.createFailureException(propertyNotFoundException, resolverKeyPair));
        this.unresolvedKeys = ImmutableList.builder().addAll(propertyNotFoundException.getUnresolvedKeys()).add(resolverKeyPair).build();
    }

    private static I18nMessage createFailureException(PropertyNotFoundException propertyNotFoundException, Pair<String, String> resolverKeyPair) {
        StringBuilder messageBuilder = new StringBuilder(PropertyNotFoundException.createMessageForLeakKey(propertyNotFoundException.getUnresolvedKeys().get(0)));
        ImmutableList allPairs = ImmutableList.builder().addAll(propertyNotFoundException.getUnresolvedKeys()).add(resolverKeyPair).build();
        allPairs.stream().skip(1L).forEach(pair -> messageBuilder.append(String.format(" - within resolver %s trying to process key %s", pair.getFirst(), pair.getSecond())));
        return I18nMessageFactory.createStaticMessage(messageBuilder.toString());
    }

    public List<Pair<String, String>> getUnresolvedKeys() {
        return this.unresolvedKeys;
    }
}

