/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model.extension.xml;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.component.TypedComponentIdentifier;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.component.location.LocationPart;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.api.meta.model.config.ConfigurationModel;
import org.mule.runtime.api.meta.model.operation.OperationModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentGenerationInformation;
import org.mule.runtime.ast.api.ComponentMetadataAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.mule.runtime.ast.api.util.BaseComponentAst;
import org.mule.runtime.ast.api.util.BaseComponentAstDecorator;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.util.MuleArtifactAstCopyUtils;
import org.mule.runtime.config.internal.dsl.model.extension.xml.MacroExpandedComponentAst;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.GlobalElementComponentModelModelProperty;
import org.mule.runtime.config.internal.dsl.model.extension.xml.property.OperationComponentModelModelProperty;
import org.mule.runtime.dsl.api.component.config.DefaultComponentLocation;

public class MacroExpansionModuleModel {
    public static final String MODULE_CONFIG_GLOBAL_ELEMENT_NAME = "config";
    public static final String MODULE_CONNECTION_GLOBAL_ELEMENT_NAME = "connection";
    public static final String MODULE_OPERATION_CONFIG_REF = "config-ref";
    public static final String TNS_PREFIX = "tns";
    public static final String DEFAULT_GLOBAL_ELEMENTS = "_defaultGlobalElements";
    private static final String DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX = "%s-default-config-global-element-suffix";
    private final ArtifactAst applicationModel;
    private final ExtensionModel extensionModel;

    MacroExpansionModuleModel(ArtifactAst applicationModel, ExtensionModel extensionModel) {
        this.applicationModel = applicationModel;
        this.extensionModel = extensionModel;
    }

    public ArtifactAst expand() {
        List<ComponentAst> moduleGlobalElements = this.getModuleGlobalElements();
        Set<String> moduleGlobalElementsNames = moduleGlobalElements.stream().map(ComponentAst::getComponentId).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toSet());
        return this.expand(moduleGlobalElements, moduleGlobalElementsNames);
    }

    private ArtifactAst expand(List<ComponentAst> moduleComponentModels, Set<String> moduleGlobalElementsNames) {
        return MuleArtifactAstCopyUtils.copyRecursively(this.applicationModel, comp -> {
            if (comp.getIdentifier().getNamespace().equals(this.extensionModel.getXmlDslModel().getPrefix())) {
                if (comp.getModel(OperationModel.class).isPresent()) {
                    return comp.getModel(OperationModel.class).map(operationModel -> this.expandOperation((ComponentAst)comp, (OperationModel)operationModel, moduleGlobalElementsNames, Optional.empty())).orElse((ComponentAst)comp);
                }
                if (comp.getModel(ConfigurationModel.class).isPresent()) {
                    return comp.getModel(ConfigurationModel.class).map(configurationModel -> this.expandGlobalElement(moduleComponentModels, moduleGlobalElementsNames, (ComponentAst)comp, (ConfigurationModel)configurationModel)).orElse((ComponentAst)comp);
                }
            }
            return comp;
        }, () -> this.macroExpandDefaultGlobalElements(moduleGlobalElementsNames).map(Collections::singletonList).orElse(Collections.emptyList()), comp -> false);
    }

    private Optional<String> defaultGlobalElementName() {
        Optional<String> defaultElementName = Optional.empty();
        if (this.extensionModel.getConfigurationModels().isEmpty() && this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).isPresent()) {
            defaultElementName = this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(globalElementComponentModelModelProperty -> String.format(DEFAULT_CONFIG_GLOBAL_ELEMENT_SUFFIX, this.extensionModel.getName()));
        }
        return defaultElementName;
    }

    private Optional<ComponentAst> macroExpandDefaultGlobalElements(Set<String> moduleGlobalElementsNames) {
        return this.defaultGlobalElementName().map(defaultGlobalElementSuffix -> {
            List<ComponentAst> globalElements = this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).get().getGlobalElements();
            final List mappedGlobalElements = globalElements.stream().map(globalElement -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively(globalElement, comp -> new MacroExpandedComponentAst((ComponentAst)comp, this.resolveMacroExpandedLocation((String)defaultGlobalElementSuffix, (ComponentAst)globalElement, (ComponentAst)comp), moduleGlobalElementsNames, (String)defaultGlobalElementSuffix, comp.directChildrenStream().collect(Collectors.toList())))).collect(Collectors.toList());
            return new BaseComponentAst(){
                private final ComponentIdentifier identifier;
                {
                    this.identifier = ComponentIdentifier.builder().namespaceUri(MacroExpansionModuleModel.this.extensionModel.getXmlDslModel().getNamespace()).namespace(MacroExpansionModuleModel.this.extensionModel.getXmlDslModel().getPrefix()).name(MacroExpansionModuleModel.DEFAULT_GLOBAL_ELEMENTS).build();
                }

                @Override
                public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
                    return Stream.concat(Stream.of(this), mappedGlobalElements.stream().flatMap(g -> g.recursiveStream(direction)));
                }

                @Override
                public Spliterator<ComponentAst> recursiveSpliterator(AstTraversalDirection direction) {
                    return this.recursiveStream(direction).spliterator();
                }

                @Override
                public List<ComponentAst> directChildren() {
                    return mappedGlobalElements;
                }

                @Override
                public Collection<ComponentParameterAst> getParameters() {
                    return Collections.emptySet();
                }

                @Override
                public ComponentParameterAst getParameter(String groupName, String paramName) {
                    throw new NoSuchElementException("_defaultGlobalElements does not have parameters");
                }

                @Override
                public ExtensionModel getExtensionModel() {
                    return MacroExpansionModuleModel.this.extensionModel;
                }

                @Override
                public <M> Optional<M> getModel(Class<M> modelClass) {
                    return Optional.empty();
                }

                @Override
                public MetadataType getType() {
                    return null;
                }

                @Override
                public Map<String, Object> getAnnotations() {
                    return Collections.emptyMap();
                }

                @Override
                public ComponentMetadataAst getMetadata() {
                    return ComponentMetadataAst.EMPTY_METADATA;
                }

                @Override
                public ComponentGenerationInformation getGenerationInformation() {
                    return ComponentGenerationInformation.EMPTY_GENERATION_INFO;
                }

                @Override
                public ComponentLocation getLocation() {
                    return DefaultComponentLocation.from(MacroExpansionModuleModel.DEFAULT_GLOBAL_ELEMENTS);
                }

                @Override
                public ComponentIdentifier getIdentifier() {
                    return this.identifier;
                }

                @Override
                public TypedComponentIdentifier.ComponentType getComponentType() {
                    return null;
                }

                @Override
                public Optional<String> getComponentId() {
                    return Optional.empty();
                }
            };
        });
    }

    private ComponentAst expandGlobalElement(List<ComponentAst> moduleComponentModels, Set<String> moduleGlobalElementsNames, ComponentAst comp, ConfigurationModel configurationModel) {
        Map<String, String> propertiesMap = comp.getParameters().stream().filter(paramAst -> paramAst.getValue().isRight()).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getValue().getRight().toString()));
        Map<String, String> connectionPropertiesMap = this.extractConnectionProperties(comp, configurationModel);
        propertiesMap.putAll(connectionPropertiesMap);
        Map<String, String> literalsParameters = this.getLiteralParameters(propertiesMap, Collections.emptyMap());
        String defaultGlobalElementSuffix = comp.getComponentId().orElse("");
        final List mappedModuleComponentModels = moduleComponentModels.stream().map(nestedComp -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively(nestedComp, c -> new MacroExpandedComponentAst((ComponentAst)c, this.resolveMacroExpandedLocation(defaultGlobalElementSuffix, (ComponentAst)nestedComp, (ComponentAst)c), moduleGlobalElementsNames, defaultGlobalElementSuffix, literalsParameters, c.directChildrenStream().collect(Collectors.toList())))).collect(Collectors.toList());
        return new BaseComponentAstDecorator(comp){

            @Override
            public Stream<ComponentAst> directChildrenStream() {
                return mappedModuleComponentModels.stream();
            }
        };
    }

    private Optional<ConfigurationModel> getConfigurationModel() {
        return this.extensionModel.getConfigurationModel(MODULE_CONFIG_GLOBAL_ELEMENT_NAME);
    }

    private ComponentLocation resolveMacroExpandedLocation(String defaultGlobalElementSuffix, ComponentAst macroExpandedComp, ComponentAst innerComp) {
        ArrayList<DefaultComponentLocation.DefaultLocationPart> parts = new ArrayList<DefaultComponentLocation.DefaultLocationPart>();
        LocationPart firstPart = macroExpandedComp.getLocation().getParts().get(0);
        parts.add(new DefaultComponentLocation.DefaultLocationPart(macroExpandedComp.getComponentId().map(id -> id.concat("-").concat(defaultGlobalElementSuffix)).orElse(defaultGlobalElementSuffix), firstPart.getPartIdentifier(), firstPart.getFileName(), firstPart.getLine(), firstPart.getColumn()));
        innerComp.getLocation().getParts().stream().skip(2L).map(lp -> (DefaultComponentLocation.DefaultLocationPart)lp).forEach(parts::add);
        return new DefaultComponentLocation(innerComp.getComponentId(), parts);
    }

    private List<ComponentAst> getModuleGlobalElements() {
        return this.extensionModel.getModelProperty(GlobalElementComponentModelModelProperty.class).map(GlobalElementComponentModelModelProperty::getGlobalElements).orElse(Collections.emptyList());
    }

    private ComponentAst expandOperation(ComponentAst operationRefModel, OperationModel operationModel, Set<String> moduleGlobalElementsNames, Optional<String> configRefParentTnsName) {
        OperationComponentModelModelProperty operationComponentModelModelProperty = operationModel.getModelProperty(OperationComponentModelModelProperty.class).get();
        ComponentAst operationModuleComponentModel = operationComponentModelModelProperty.getBodyComponentModel();
        Optional<String> configRefName = this.referencesOperationsWithinModule(operationRefModel) ? configRefParentTnsName : this.getConfigRefName(operationRefModel);
        Map<String, String> propertiesMap = this.extractProperties(configRefName);
        Map<String, String> parametersMap = operationRefModel.getParameters().stream().filter(paramAst -> paramAst.getResolvedRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getResolvedRawValue()));
        Map<String, String> literalParameters = this.getLiteralParameters(propertiesMap, parametersMap);
        final List processorChainChildren = operationModuleComponentModel.directChildrenStream().map(bodyProcessor -> MuleArtifactAstCopyUtils.copyComponentTreeRecursively(bodyProcessor, operationChildModel -> this.lookForTNSOperation((ComponentAst)operationChildModel).map(tnsOperation -> this.expandOperation((ComponentAst)operationChildModel, (OperationModel)tnsOperation, moduleGlobalElementsNames, configRefName)).orElseGet(() -> new MacroExpandedComponentAst((ComponentAst)operationChildModel, operationChildModel.getLocation(), moduleGlobalElementsNames, configRefName.orElse(""), literalParameters, operationChildModel.directChildrenStream().collect(Collectors.toList()))))).collect(Collectors.toList());
        return new BaseComponentAstDecorator(operationRefModel){

            @Override
            public Stream<ComponentAst> directChildrenStream() {
                return Stream.concat(super.directChildrenStream(), processorChainChildren.stream());
            }
        };
    }

    private Optional<String> getConfigRefName(ComponentAst operationRefModel) {
        ComponentParameterAst parameterAst = operationRefModel.getParameter("General", MODULE_OPERATION_CONFIG_REF);
        if (parameterAst != null && parameterAst.getResolvedRawValue() != null) {
            return Optional.of(parameterAst.getResolvedRawValue());
        }
        return this.defaultGlobalElementName();
    }

    private Map<String, String> getLiteralParameters(Map<String, String> propertiesMap, Map<String, String> parametersMap) {
        Map<String, String> literalsParameters = propertiesMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue));
        literalsParameters.putAll(parametersMap.entrySet().stream().filter(entry -> !this.isExpression((String)entry.getValue())).collect(Collectors.toMap(e -> this.getReplaceableExpression((String)e.getKey(), "vars"), Map.Entry::getValue)));
        return literalsParameters;
    }

    private String getReplaceableExpression(String name, String prefix) {
        return "#[" + prefix + "." + name + "]";
    }

    private boolean isExpression(String value) {
        return value.startsWith("#[") && value.endsWith("]");
    }

    private Map<String, String> extractProperties(Optional<String> configRefName) {
        HashMap<String, String> valuesMap = new HashMap<String, String>();
        configRefName.filter(configParameter -> this.defaultGlobalElementName().map(defaultGlobalElementName -> !defaultGlobalElementName.equals(configParameter)).orElse(true)).ifPresent(configParameter -> {
            ComponentAst configRefComponentModel = this.applicationModel.filteredComponents(ComponentAstPredicatesFactory.equalsNamespace(this.extensionModel.getXmlDslModel().getPrefix())).filter(componentModel -> componentModel.getModel(ConfigurationModel.class).isPresent() && configParameter.equals(componentModel.getComponentId().orElse(null))).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("There's no <%s:config> named [%s] in the current mule app", this.extensionModel.getXmlDslModel().getPrefix(), configParameter)));
            ConfigurationModel configurationModel = this.getConfigurationModel().get();
            configRefComponentModel.getParameters().stream().filter(paramAst -> paramAst.getResolvedRawValue() != null).forEach(paramAst -> valuesMap.put(paramAst.getModel().getName(), paramAst.getResolvedRawValue()));
            valuesMap.putAll(this.extractConnectionProperties(configRefComponentModel, configurationModel));
        });
        return valuesMap;
    }

    private Map<String, String> extractConnectionProperties(ComponentAst configRefComponentModel, ConfigurationModel configurationModel) {
        return configurationModel.getConnectionProviderModel(MODULE_CONNECTION_GLOBAL_ELEMENT_NAME).flatMap(connectionProviderModel -> configRefComponentModel.directChildrenStream().filter(componentModel -> MODULE_CONNECTION_GLOBAL_ELEMENT_NAME.equals(componentModel.getIdentifier().getName())).findFirst().map(connectionComponentModel -> connectionComponentModel.getParameters().stream().filter(paramAst -> paramAst.getResolvedRawValue() != null).collect(Collectors.toMap(paramAst -> paramAst.getModel().getName(), paramAst -> paramAst.getResolvedRawValue())))).orElse(Collections.emptyMap());
    }

    private boolean referencesOperationsWithinModule(ComponentAst operationComponentModel) {
        return TNS_PREFIX.equals(operationComponentModel.getIdentifier().getNamespace());
    }

    private Optional<OperationModel> lookForTNSOperation(ComponentAst componentModel) {
        if (this.referencesOperationsWithinModule(componentModel)) {
            return componentModel.getModel(OperationModel.class);
        }
        return Optional.empty();
    }
}

