/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.mule.runtime.api.component.ComponentIdentifier;
import org.mule.runtime.api.message.ErrorType;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.AbstractErrorTypesValidation;
import org.mule.runtime.extension.api.error.ErrorMapping;

public class ErrorMappingSourceTypeReferencesExist
extends AbstractErrorTypesValidation {
    @Override
    public String getName() {
        return "Error Type references exist";
    }

    @Override
    public String getDescription() {
        return "Referenced error types do exist in the context of the artifact.";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        return ComponentAstPredicatesFactory.currentElemement(AbstractErrorTypesValidation::errorMappingPresent);
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        for (ErrorMapping errorMapping : ErrorMappingSourceTypeReferencesExist.getErrorMappings(component)) {
            ComponentIdentifier errorTypeId = ErrorMappingSourceTypeReferencesExist.parserErrorType(errorMapping.getSource());
            Optional<ErrorType> errorType = artifact.getErrorTypeRepository().lookupErrorType(errorTypeId);
            if (errorType.isPresent()) continue;
            return Optional.of(ValidationResultItem.create(component, component.getParameter("Error Mappings", "errorMappings"), (Validation)this, String.format("Could not find error '%s'.", errorMapping.getSource())));
        }
        return Optional.empty();
    }
}

