/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.processor.strategy.reactor.builder;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.mule.runtime.api.component.location.ComponentLocation;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.api.profiling.type.context.ProcessingStrategyProfilingEventContext;
import org.mule.runtime.api.scheduler.Scheduler;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.processor.strategy.reactor.builder.ReactorPublisherBuilder;
import org.mule.runtime.core.internal.processor.strategy.util.ProfilingUtils;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;

public class ComponentProcessingStrategyReactiveProcessorBuilder {
    private final ReactiveProcessor processor;
    private final Scheduler contextScheduler;
    private final String artifactId;
    private final String artifactType;
    private int parallelism = 1;
    private ScheduledExecutorService dispatcherScheduler;
    private ScheduledExecutorService callbackScheduler;
    private ProfilingService profilingService;

    public ComponentProcessingStrategyReactiveProcessorBuilder(ReactiveProcessor processor, Scheduler contextScheduler, String artifactId, String artifactType) {
        this.processor = processor;
        this.contextScheduler = contextScheduler;
        this.artifactId = artifactId;
        this.artifactType = artifactType;
    }

    public static ComponentProcessingStrategyReactiveProcessorBuilder processingStrategyReactiveProcessorFrom(ReactiveProcessor processor, Scheduler contextScheduler, String artifactId, String artifactType) {
        return new ComponentProcessingStrategyReactiveProcessorBuilder(processor, contextScheduler, artifactId, artifactType);
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withParallelism(int parallelism) {
        this.parallelism = parallelism;
        return this;
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withDispatcherScheduler(ScheduledExecutorService dispatcherScheduler) {
        this.dispatcherScheduler = dispatcherScheduler;
        return this;
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withCallbackScheduler(ScheduledExecutorService callbackScheduler) {
        this.callbackScheduler = callbackScheduler;
        return this;
    }

    public ComponentProcessingStrategyReactiveProcessorBuilder withProfilingService(ProfilingService profilingService) {
        this.profilingService = profilingService;
        return this;
    }

    public ReactiveProcessor build() {
        if (this.parallelism == 1) {
            return publisher -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildFlux((Publisher<CoreEvent>)publisher)).build();
        }
        return publisher -> Flux.from((Publisher)publisher).flatMap(e -> this.baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder.buildMono(e)).build(), this.parallelism);
    }

    private <T extends Publisher> ReactorPublisherBuilder<T> baseProcessingStrategyPublisherBuilder(ReactorPublisherBuilder<T> builder) {
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> psSchedulingOperationExecutionDataProducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION);
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> startingOperationExecutionDataProducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION);
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> operationExecutionDataProducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.OPERATION_EXECUTED);
        Optional<ProfilingDataProducer<ProcessingStrategyProfilingEventContext>> psFlowMessagePassingDataProducer = this.dataProducerFromProfilingService(RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING);
        ComponentLocation location = ProfilingUtils.getLocation(this.processor);
        return builder.profileEvent(location, psSchedulingOperationExecutionDataProducer, this.artifactId, this.artifactType).publishOn(Optional.ofNullable(this.dispatcherScheduler)).profileEvent(location, startingOperationExecutionDataProducer, this.artifactId, this.artifactType).transform(this.processor).profileEvent(location, operationExecutionDataProducer, this.artifactId, this.artifactType).publishOn(Optional.ofNullable(this.callbackScheduler)).profileEvent(location, psFlowMessagePassingDataProducer, this.artifactId, this.artifactType).subscriberContext(ctx -> ctx.put((Object)"mule.nb.processorScheduler", (Object)this.contextScheduler));
    }

    private <T extends ProfilingEventContext> Optional<ProfilingDataProducer<T>> dataProducerFromProfilingService(ProfilingEventType<T> profilingEventType) {
        return Optional.ofNullable(this.profilingService).map(ds -> ds.getProfilingDataProducer(profilingEventType));
    }
}

