/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling;

import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import org.mule.runtime.api.config.FeatureFlaggingService;
import org.mule.runtime.api.config.MuleRuntimeFeature;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.lifecycle.Stoppable;
import org.mule.runtime.api.notification.NotificationListener;
import org.mule.runtime.api.profiling.ProfilingDataConsumer;
import org.mule.runtime.api.profiling.ProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.ProfilingService;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.core.api.config.FeatureFlaggingRegistry;
import org.mule.runtime.core.api.context.notification.ServerNotificationHandler;
import org.mule.runtime.core.api.context.notification.ServerNotificationManager;
import org.mule.runtime.core.internal.profiling.DefaultProfilingNotificationListener;
import org.mule.runtime.core.internal.profiling.notification.ProfilingNotification;

public abstract class AbstractProfilingService
implements ProfilingService,
Initialisable,
Startable,
Stoppable {
    @Inject
    protected ServerNotificationManager notificationManager;
    @Inject
    private ServerNotificationHandler serverNotificationHandler;
    private FeatureFlaggingService featureFlags;
    private final Set<NotificationListener<?>> addedListeners = new HashSet();

    @Override
    public void initialise() throws InitialisationException {
    }

    @Override
    public void start() throws MuleException {
        if (this.featureFlags.isEnabled(MuleRuntimeFeature.ENABLE_PROFILING_SERVICE)) {
            this.registerNotificationListeners(this.getDiscoveryStrategy().discover());
        }
    }

    private <S extends ProfilingDataConsumer<T>, T extends ProfilingEventContext> void registerNotificationListeners(Set<S> profilingDataConsumers) {
        profilingDataConsumers.forEach(this::registerNotificationListener);
    }

    private <T extends ProfilingEventContext> void registerNotificationListener(ProfilingDataConsumer<T> profilingDataConsumer) {
        DefaultProfilingNotificationListener<T> profilingNotificationListener = new DefaultProfilingNotificationListener<T>(profilingDataConsumer);
        this.notificationManager.addListenerSubscription(profilingNotificationListener, pn -> this.filterByAction(profilingDataConsumer, (ProfilingNotification)pn));
        this.addedListeners.add(profilingNotificationListener);
    }

    private <T extends ProfilingEventContext> boolean filterByAction(ProfilingDataConsumer<T> profilingDataConsumer, ProfilingNotification<T> profilingNotification) {
        return profilingDataConsumer.getProfilingEventTypes().stream().anyMatch(eventType -> ProfilingNotification.getFullyQualifiedProfilingNotificationIdentifier(eventType).equalsIgnoreCase(profilingNotification.getActionName())) && profilingDataConsumer.getEventContextFilter().test((ProfilingEventContext)profilingNotification.getSource());
    }

    @Override
    public void stop() {
        if (!this.notificationManager.isDisposed()) {
            this.addedListeners.forEach(listener -> this.notificationManager.removeListener((NotificationListener<?>)listener));
        }
    }

    protected abstract ProfilingDataConsumerDiscoveryStrategy getDiscoveryStrategy();

    public <T extends ProfilingEventContext> void notifyEvent(T profilingEventContext, ProfilingEventType<T> action) {
        this.serverNotificationHandler.fireNotification(new ProfilingNotification<T>(profilingEventContext, action));
    }

    @Inject
    public void setFeatureFlags(FeatureFlaggingService featureFlags) {
        this.featureFlags = featureFlags;
    }

    public static void configureEnableProfilingService() {
        FeatureFlaggingRegistry featureFlaggingRegistry = FeatureFlaggingRegistry.getInstance();
        featureFlaggingRegistry.registerFeatureFlag(MuleRuntimeFeature.ENABLE_PROFILING_SERVICE, featureContext -> featureContext.getArtifactMinMuleVersion().filter(muleVersion -> muleVersion.atLeast(MuleRuntimeFeature.ENABLE_PROFILING_SERVICE.getSince())).isPresent());
    }
}

