/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.profiling;

import java.util.HashMap;
import java.util.Map;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.profiling.ProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.api.profiling.ProfilingDataProducer;
import org.mule.runtime.api.profiling.ProfilingEventContext;
import org.mule.runtime.api.profiling.type.ProfilingEventType;
import org.mule.runtime.api.profiling.type.RuntimeProfilingEventTypes;
import org.mule.runtime.core.internal.profiling.AbstractProfilingService;
import org.mule.runtime.core.internal.profiling.DefaultProfilingDataConsumerDiscoveryStrategy;
import org.mule.runtime.core.internal.profiling.producer.ComponentProcessingStrategyProfilingDataProducer;

public class DefaultProfilingService
extends AbstractProfilingService {
    protected Map<ProfilingEventType<? extends ProfilingEventContext>, ProfilingDataProducer<?>> profilingDataProducers = new HashMap(){
        {
            this.put(RuntimeProfilingEventTypes.FLOW_EXECUTED, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.FLOW_EXECUTED));
            this.put(RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.PS_SCHEDULING_FLOW_EXECUTION));
            this.put(RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.STARTING_FLOW_EXECUTION));
            this.put(RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.PS_FLOW_MESSAGE_PASSING));
            this.put(RuntimeProfilingEventTypes.OPERATION_EXECUTED, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.OPERATION_EXECUTED));
            this.put(RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.PS_SCHEDULING_OPERATION_EXECUTION));
            this.put(RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION, new ComponentProcessingStrategyProfilingDataProducer(DefaultProfilingService.this, RuntimeProfilingEventTypes.STARTING_OPERATION_EXECUTION));
        }
    };

    @Override
    public ProfilingDataConsumerDiscoveryStrategy getDiscoveryStrategy() {
        return new DefaultProfilingDataConsumerDiscoveryStrategy();
    }

    @Override
    public <T extends ProfilingEventContext> ProfilingDataProducer<T> getProfilingDataProducer(ProfilingEventType<T> profilingEventType) {
        if (!this.profilingDataProducers.containsKey(profilingEventType)) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage(String.format("Profiling event type not registered: %s", profilingEventType)));
        }
        return this.profilingDataProducers.get(profilingEventType);
    }

    @Override
    public <T extends ProfilingEventContext> void registerProfilingDataProducer(ProfilingEventType<T> profilingEventType, ProfilingDataProducer<T> profilingDataProducer) {
        this.profilingDataProducers.put(profilingEventType, profilingDataProducer);
    }
}

