/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.extension.api.model.parameter;

import java.util.Objects;
import org.mule.runtime.api.meta.model.parameter.ActingParameterModel;
import org.mule.runtime.api.util.Preconditions;

public class ImmutableActingParameterModel
implements ActingParameterModel {
    private final String name;
    private final boolean required;
    private final String extractionExpression;

    public ImmutableActingParameterModel(String name, boolean required) {
        this(name, required, name);
    }

    public ImmutableActingParameterModel(String name, boolean required, String extractionExpression) {
        Preconditions.checkArgument(name != null && name.length() > 0, "name cannot be null or blank");
        this.name = name;
        this.required = required;
        this.extractionExpression = extractionExpression;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public String getExtractionExpression() {
        return this.extractionExpression;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ImmutableActingParameterModel)) {
            return false;
        }
        ImmutableActingParameterModel that = (ImmutableActingParameterModel)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.required, that.required) && Objects.equals(this.extractionExpression, that.extractionExpression);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.required, this.extractionExpression);
    }
}

