/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.http.policy.api;

import java.util.Objects;
import org.mule.runtime.api.component.Component;
import org.mule.runtime.api.util.MultiMap;
import org.mule.runtime.policy.api.PolicyPointcutParameters;

public abstract class HttpPolicyPointcutParameters
extends PolicyPointcutParameters {
    private final String path;
    private final String method;
    private String maskedRequestPath;
    private MultiMap<String, String> headers;

    public HttpPolicyPointcutParameters(Component component, String path, String method) {
        this(component, null, path, method);
    }

    public HttpPolicyPointcutParameters(Component component, PolicyPointcutParameters sourceParameters, String path, String method) {
        this(component, sourceParameters, path, method, null, MultiMap.emptyMultiMap());
    }

    public HttpPolicyPointcutParameters(Component component, PolicyPointcutParameters sourceParameters, String path, String method, String maskedRequestPath, MultiMap<String, String> headers) {
        super(component, sourceParameters);
        this.path = path;
        this.method = method;
        this.maskedRequestPath = maskedRequestPath;
        this.headers = headers;
    }

    public String getPath() {
        return this.path;
    }

    public String getMethod() {
        return this.method;
    }

    public String getMaskedRequestPath() {
        return this.maskedRequestPath;
    }

    public MultiMap<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(MultiMap<String, String> headers) {
        this.headers = headers;
    }

    public void setMaskedRequestPath(String maskedRequestPath) {
        this.maskedRequestPath = maskedRequestPath;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getComponent(), this.getSourceParameters(), this.method, this.path, this.getHeaders());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HttpPolicyPointcutParameters other = (HttpPolicyPointcutParameters)obj;
        return Objects.equals(this.getComponent(), other.getComponent()) && Objects.equals(this.getSourceParameters(), other.getSourceParameters()) && Objects.equals(this.method, other.method) && Objects.equals(this.path, other.path) && Objects.equals(this.getHeaders(), other.getHeaders());
    }
}

