/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.deployment.internal;

import java.io.IOException;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.mule.runtime.core.internal.context.ArtifactStoppedPersistenceListener;
import org.mule.runtime.module.deployment.impl.internal.util.DeploymentPropertiesUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ArtifactStoppedDeploymentPersistenceListener
implements ArtifactStoppedPersistenceListener {
    private static final transient Logger logger = LoggerFactory.getLogger(ArtifactStoppedDeploymentPersistenceListener.class);
    private AtomicBoolean shouldPersist;
    private String artifactName;

    public ArtifactStoppedDeploymentPersistenceListener(String artifactName) {
        this.artifactName = artifactName;
        this.shouldPersist = new AtomicBoolean(true);
    }

    @Override
    public void onStart() {
        Properties properties = new Properties();
        properties.setProperty("startArtifactOnDeployment", String.valueOf(true));
        try {
            DeploymentPropertiesUtils.resolveDeploymentProperties(this.artifactName, Optional.of(properties));
        }
        catch (IOException e) {
            logger.error("ArtifactStoppedDeploymentPersistenceListener failed to process notification onStart for artifact " + this.artifactName, (Throwable)e);
        }
    }

    @Override
    public void onStop() {
        if (!this.shouldPersist.get()) {
            return;
        }
        Properties properties = new Properties();
        properties.setProperty("startArtifactOnDeployment", String.valueOf(false));
        try {
            DeploymentPropertiesUtils.resolveDeploymentProperties(this.artifactName, Optional.of(properties));
        }
        catch (IOException e) {
            logger.error("ArtifactStoppedDeploymentPersistenceListener failed to process notification onStop for artifact " + this.artifactName, (Throwable)e);
        }
    }

    @Override
    public void doNotPersist() {
        this.shouldPersist.set(false);
    }
}

