/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.capability.xml.description;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.mule.runtime.extension.api.annotation.Alias;
import org.mule.runtime.module.extension.internal.capability.xml.schema.ExtensionAnnotationProcessor;
import org.mule.runtime.module.extension.internal.util.IntrospectionUtils;

abstract class AbstractDescriptionDocumenter {
    protected static final ExtensionAnnotationProcessor processor = new ExtensionAnnotationProcessor();
    protected final TypeElement objectType;
    protected static final String VALUE_PROPERTY = "value";
    final ProcessingEnvironment processingEnv;

    AbstractDescriptionDocumenter(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        this.objectType = this.processingEnv.getElementUtils().getTypeElement(Object.class.getCanonicalName());
    }

    String getNameOrAlias(Element element) {
        return this.getAlias(element).orElse(element.getSimpleName().toString());
    }

    Optional<String> getAlias(Element element) {
        Alias annotation = element.getAnnotation(Alias.class);
        return annotation != null ? Optional.of(annotation.value()) : Optional.empty();
    }

    Map<String, Element> getApiMethods(ProcessingEnvironment processingEnv, List<TypeElement> containerClasses) {
        HashMap methods = new HashMap();
        Iterator<TypeElement> iterator = containerClasses.iterator();
        while (iterator.hasNext()) {
            TypeElement containerElement;
            TypeElement currentElement = containerElement = iterator.next();
            while (currentElement != null && !processingEnv.getTypeUtils().isSameType(currentElement.asType(), this.objectType.asType())) {
                for (ExecutableElement operation : IntrospectionUtils.getApiMethods(currentElement, processingEnv)) {
                    currentElement.getEnclosedElements().stream().filter(e -> e.getSimpleName().toString().equals(operation.getSimpleName().toString())).findFirst().ifPresent(e -> {
                        String nameOrAlias = this.getNameOrAlias(operation);
                        if (!methods.containsKey(nameOrAlias) || e.getEnclosingElement().equals(containerElement)) {
                            methods.put(nameOrAlias, e);
                        }
                    });
                }
                Element superClass = processingEnv.getTypeUtils().asElement(currentElement.getSuperclass());
                if (superClass instanceof TypeElement) {
                    currentElement = (TypeElement)superClass;
                    continue;
                }
                currentElement = null;
            }
        }
        return Collections.unmodifiableMap(methods);
    }
}

