/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.management.stats.CursorComponentDecoratorFactory;
import org.mule.runtime.core.api.streaming.CursorProviderFactory;
import org.mule.runtime.core.api.streaming.StreamingManager;
import org.mule.runtime.core.api.streaming.bytes.CursorStreamProviderFactory;
import org.mule.runtime.core.api.streaming.object.CursorIteratorProviderFactory;
import org.mule.runtime.extension.api.runtime.operation.ExecutionContext;
import org.mule.runtime.extension.api.runtime.streaming.StreamingHelper;
import org.mule.runtime.module.extension.api.runtime.privileged.ExecutionContextAdapter;
import org.mule.runtime.module.extension.internal.runtime.resolver.ArgumentResolver;
import org.mule.runtime.module.extension.internal.runtime.streaming.DefaultStreamingHelper;

public class StreamingHelperArgumentResolver
implements ArgumentResolver<StreamingHelper> {
    private boolean initialized = false;
    private CursorStreamProviderFactory cursorStreamProviderFactory;
    private CursorIteratorProviderFactory cursorIteratorProviderFactory;
    private CursorComponentDecoratorFactory componentDecoratorFactory;

    @Override
    public StreamingHelper resolve(ExecutionContext executionContext) {
        this.initializeCursorProviderFactoriesIfNeeded(executionContext);
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        return new DefaultStreamingHelper(this.cursorStreamProviderFactory, this.cursorIteratorProviderFactory, this.componentDecoratorFactory, context.getEvent(), context.getComponent().getLocation());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeCursorProviderFactoriesIfNeeded(ExecutionContext executionContext) {
        if (!this.initialized) {
            StreamingHelperArgumentResolver streamingHelperArgumentResolver = this;
            synchronized (streamingHelperArgumentResolver) {
                if (!this.initialized) {
                    this.doInitializeCursorProviderFactories(executionContext);
                    this.initialized = true;
                }
            }
        }
    }

    private void doInitializeCursorProviderFactories(ExecutionContext executionContext) {
        ExecutionContextAdapter context = (ExecutionContextAdapter)executionContext;
        StreamingManager streamingManager = context.getStreamingManager();
        CursorProviderFactory cursorProviderFactory = context.getCursorProviderFactory();
        Pair<CursorStreamProviderFactory, CursorIteratorProviderFactory> cursorProviderFactories = streamingManager.getPairFor(cursorProviderFactory);
        this.cursorStreamProviderFactory = cursorProviderFactories.getFirst();
        this.cursorIteratorProviderFactory = cursorProviderFactories.getSecond();
        this.componentDecoratorFactory = context.getComponentDecoratorFactory();
    }
}

