/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.scheduler.internal;

import java.lang.reflect.Field;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableFuture;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

abstract class AbstractRunnableFutureDecorator<V>
implements RunnableFuture<V> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractRunnableFutureDecorator.class);
    private ClassLoader classLoader;
    private Thread runningThread;
    private static Field threadLocalsField;
    private final int id;
    private volatile boolean ranAtLeastOnce = false;
    private volatile boolean started = false;

    protected static void clearAllThreadLocals() {
        try {
            threadLocalsField.set(Thread.currentThread(), null);
        }
        catch (Exception e) {
            throw new MuleRuntimeException(e);
        }
    }

    protected AbstractRunnableFutureDecorator(int id, ClassLoader classLoader) {
        this.id = id;
        this.classLoader = classLoader;
    }

    protected long beforeRun() {
        long startTime = 0L;
        if (logger.isTraceEnabled()) {
            startTime = System.nanoTime();
            logger.trace("Starting task " + this.toString() + "...");
        }
        this.ranAtLeastOnce = true;
        this.started = true;
        return startTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doRun(RunnableFuture<V> task) {
        ClassLoader cl = this.classLoader;
        if (cl == null) {
            if (!logger.isDebugEnabled()) return;
            logger.debug("Task " + this.toString() + " has been cancelled. Retunrning immendiately.");
            return;
        }
        long startTime = this.beforeRun();
        Thread currentThread = Thread.currentThread();
        ClassLoader currentClassLoader = currentThread.getContextClassLoader();
        String currentThreadName = currentThread.getName();
        currentThread.setContextClassLoader(cl);
        if (this.getThreadNameSuffix() != null) {
            currentThread.setName(currentThreadName.concat(": ").concat(this.getThreadNameSuffix()));
        }
        this.runningThread = currentThread;
        if (logger.isTraceEnabled()) {
            MDC.put((String)"task", (String)task.toString());
        }
        try {
            task.run();
            if (task.isCancelled()) {
                if (!logger.isTraceEnabled()) return;
                logger.trace("Task " + this.toString() + " cancelled");
                return;
            }
            task.get();
            return;
        }
        catch (ExecutionException e) {
            logger.error("Uncaught throwable in task " + this.toString(), (Throwable)e);
            return;
        }
        catch (InterruptedException e) {
            currentThread.interrupt();
            return;
        }
        finally {
            try {
                this.wrapUp();
            }
            catch (Exception e) {
                logger.error("Exception wrapping up execution of " + this.toString(), (Throwable)e);
            }
            finally {
                if (logger.isTraceEnabled()) {
                    logger.trace("Task " + this.toString() + " finished after " + (System.nanoTime() - startTime) + " nanoseconds");
                }
                currentThread.setContextClassLoader(currentClassLoader);
                if (this.getThreadNameSuffix() != null) {
                    currentThread.setName(currentThreadName);
                }
            }
        }
    }

    protected void resetClassloader() {
        this.classLoader = null;
    }

    protected void wrapUp() throws Exception {
        this.started = false;
        this.runningThread = null;
        AbstractRunnableFutureDecorator.clearAllThreadLocals();
    }

    boolean isRanAtLeastOnce() {
        return this.ranAtLeastOnce;
    }

    boolean isStarted() {
        return this.started;
    }

    public Thread getRunningThread() {
        return this.runningThread;
    }

    public int hashCode() {
        return Integer.hashCode(this.id);
    }

    public abstract String getSchedulerName();

    public abstract String getThreadNameSuffix();

    static {
        try {
            threadLocalsField = Thread.class.getDeclaredField("threadLocals");
            threadLocalsField.setAccessible(true);
        }
        catch (NoSuchFieldException | SecurityException e) {
            throw new RuntimeException(e);
        }
    }
}

