/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.core.internal.routing.forkjoin;

import java.util.ArrayDeque;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.mule.runtime.api.event.EventContext;
import org.mule.runtime.core.api.event.CoreEvent;
import org.mule.runtime.core.api.processor.ReactiveProcessor;
import org.mule.runtime.core.internal.event.AbstractEventContext;
import org.mule.runtime.core.internal.event.EventQuickCopy;
import org.mule.runtime.core.internal.routing.forkjoin.RoutePairPublisherAssemblyHelper;
import org.mule.runtime.core.privileged.event.BaseEventContext;
import org.mule.runtime.core.privileged.exception.MessagingException;
import org.mule.runtime.core.privileged.processor.MessageProcessors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Mono;

class DefaultRoutePairPublisherAssemblyHelper
implements RoutePairPublisherAssemblyHelper {
    private final Publisher<CoreEvent> publisherWithChildContext;
    private final BaseEventContext childContext;

    DefaultRoutePairPublisherAssemblyHelper(CoreEvent routeEvent, ReactiveProcessor chain) {
        this.childContext = MessageProcessors.newChildContext(routeEvent, Optional.empty());
        this.publisherWithChildContext = MessageProcessors.processWithChildContext(routeEvent, chain, this.childContext);
    }

    @Override
    public Publisher<CoreEvent> getPublisherOnChildContext() {
        return this.publisherWithChildContext;
    }

    @Override
    public Publisher<CoreEvent> decorateTimeoutPublisher(Publisher<CoreEvent> timeoutPublisher) {
        return Mono.from(timeoutPublisher).doOnSuccess(this.completeRecursively(this.childContext, BaseEventContext::error));
    }

    private Consumer<CoreEvent> completeRecursively(BaseEventContext eventContext, BiConsumer<BaseEventContext, MessagingException> forEachChild) {
        return some -> {
            ArrayDeque<BaseEventContext> allContexts = new ArrayDeque<BaseEventContext>();
            allContexts.push(eventContext);
            ((AbstractEventContext)eventContext).forEachChild(allContexts::push);
            while (!allContexts.isEmpty()) {
                BaseEventContext ctx = (BaseEventContext)allContexts.pop();
                if (ctx.isTerminated()) continue;
                forEachChild.accept(ctx, new MessagingException(EventQuickCopy.quickCopy((EventContext)ctx, some), some.getError().get().getCause()));
            }
        };
    }
}

