/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.loader.enricher;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.utils.MetadataTypeUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ImportedTypeModel;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclaration;
import org.mule.runtime.api.meta.model.declaration.fluent.ExtensionDeclarer;
import org.mule.runtime.api.util.collection.Collectors;
import org.mule.runtime.extension.api.annotation.SubTypeMapping;
import org.mule.runtime.extension.api.annotation.SubTypesMapping;
import org.mule.runtime.extension.api.exception.IllegalModelDefinitionException;
import org.mule.runtime.extension.api.loader.DeclarationEnricherPhase;
import org.mule.runtime.extension.api.loader.ExtensionLoadingContext;
import org.mule.runtime.module.extension.api.loader.java.type.AnnotationValueFetcher;
import org.mule.runtime.module.extension.api.loader.java.type.Type;
import org.mule.runtime.module.extension.internal.loader.enricher.AbstractAnnotatedDeclarationEnricher;
import org.mule.runtime.module.extension.internal.loader.java.MuleExtensionAnnotationParser;
import org.mule.runtime.module.extension.internal.loader.java.type.property.ExtensionTypeDescriptorModelProperty;

public final class SubTypesDeclarationEnricher
extends AbstractAnnotatedDeclarationEnricher {
    @Override
    public DeclarationEnricherPhase getExecutionPhase() {
        return DeclarationEnricherPhase.STRUCTURE;
    }

    @Override
    public void enrich(ExtensionLoadingContext extensionLoadingContext) {
        ExtensionDeclarer declarer = extensionLoadingContext.getExtensionDeclarer();
        ExtensionDeclaration extensionDeclaration = (ExtensionDeclaration)declarer.getDeclaration();
        Optional<ExtensionTypeDescriptorModelProperty> implementingType = extensionDeclaration.getModelProperty(ExtensionTypeDescriptorModelProperty.class);
        if (!implementingType.isPresent()) {
            return;
        }
        Type type = implementingType.get().getType();
        List<AnnotationValueFetcher<SubTypeMapping>> typeMappings = MuleExtensionAnnotationParser.parseRepeatableAnnotation(type, SubTypeMapping.class, c -> ((SubTypesMapping)c).value());
        if (!typeMappings.isEmpty()) {
            this.declareSubTypesMapping(declarer, typeMappings, extensionLoadingContext.getDslResolvingContext(), extensionDeclaration.getName());
        }
    }

    private void declareSubTypesMapping(ExtensionDeclarer declarer, List<AnnotationValueFetcher<SubTypeMapping>> typeMappings, DslResolvingContext dslResolvingContext, String name) {
        if (typeMappings.stream().map(valueFetcher -> valueFetcher.getClassValue(SubTypeMapping::baseType)).distinct().count() != (long)typeMappings.size()) {
            throw new IllegalModelDefinitionException(String.format("There should be only one SubtypeMapping for any given base type in extension [%s]. Duplicated base types are not allowed", name));
        }
        typeMappings.forEach(mapping -> {
            Type baseType = mapping.getClassValue(SubTypeMapping::baseType);
            List<Type> subTypes = mapping.getClassArrayValue(SubTypeMapping::subTypes);
            declarer.withSubTypes(baseType.asMetadataType(), subTypes.stream().map(Type::asMetadataType).collect(Collectors.toImmutableList()));
            this.autoImportReferencedTypes(declarer, dslResolvingContext, baseType);
            subTypes.forEach(subType -> this.autoImportReferencedTypes(declarer, dslResolvingContext, (Type)subType));
        });
    }

    private void autoImportReferencedTypes(ExtensionDeclarer declarer, DslResolvingContext dslResolvingContext, Type subType) {
        MetadataTypeUtils.getTypeId(subType.asMetadataType()).filter(importedDeclaringExtension -> subType.getDeclaringClass().map(c -> !c.getClassLoader().equals(Thread.currentThread().getContextClassLoader())).orElse(true)).ifPresent(subTypeId -> dslResolvingContext.getTypeCatalog().getType((String)subTypeId).map(ImportedTypeModel::new).ifPresent(declarer::withImportedType));
    }
}

