/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.dsl.model;

import java.io.InputStream;
import java.io.StringWriter;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.IntStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.api.util.xmlsecurity.XMLSecureFactories;
import org.mule.runtime.app.declaration.api.ArtifactDeclaration;
import org.mule.runtime.app.declaration.api.ElementDeclaration;
import org.mule.runtime.config.api.dsl.ArtifactDeclarationXmlSerializer;
import org.mule.runtime.config.api.dsl.model.DslElementModel;
import org.mule.runtime.config.api.dsl.model.DslElementModelFactory;
import org.mule.runtime.config.api.dsl.model.XmlDslElementModelConverter;
import org.mule.runtime.config.internal.dsl.model.XmlArtifactDeclarationLoader;
import org.mule.runtime.internal.dsl.DslConstants;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DefaultArtifactDeclarationXmlSerializer
implements ArtifactDeclarationXmlSerializer {
    private static final String XMLNS_W3_URL = "http://www.w3.org/2000/xmlns/";
    private static final String XSI_W3_URL = "http://www.w3.org/2001/XMLSchema-instance";
    private static final String XSI_SCHEMA_LOCATION = "xsi:schemaLocation";
    private static final String XMLNS = "xmlns";
    private final DslResolvingContext context;

    public DefaultArtifactDeclarationXmlSerializer(DslResolvingContext context) {
        this.context = context;
    }

    @Override
    public String serialize(ArtifactDeclaration declaration) {
        return this.serializeArtifact(declaration);
    }

    @Override
    public ArtifactDeclaration deserialize(InputStream configResource) {
        Preconditions.checkArgument(configResource != null, "The artifact to deserialize cannot be null");
        return XmlArtifactDeclarationLoader.getDefault(this.context).load(configResource);
    }

    @Override
    public ArtifactDeclaration deserialize(String name, InputStream configResource) {
        Preconditions.checkArgument(configResource != null, "The artifact to deserialize cannot be null");
        return XmlArtifactDeclarationLoader.getDefault(this.context).load(name, configResource);
    }

    private String serializeArtifact(ArtifactDeclaration artifact) {
        Preconditions.checkArgument(artifact != null, "The artifact to serialize cannot be null");
        try {
            Document doc = this.createAppDocument(artifact);
            XmlDslElementModelConverter toXmlConverter = XmlDslElementModelConverter.getDefault(doc);
            DslElementModelFactory modelResolver = DslElementModelFactory.getDefault(this.context);
            artifact.getGlobalElements().forEach(declaration -> this.appendChildElement(toXmlConverter, doc.getDocumentElement(), modelResolver, (ElementDeclaration)((Object)declaration)));
            List<String> cDataElements = this.getCDataElements(doc.getDocumentElement());
            TransformerFactory transformerFactory = XMLSecureFactories.createDefault().getTransformerFactory();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("cdata-section-elements", StringUtils.join(cDataElements, (String)" "));
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
            DOMSource source = new DOMSource(doc);
            StringWriter writer = new StringWriter();
            transformer.transform(source, new StreamResult(writer));
            return writer.getBuffer().toString();
        }
        catch (Exception e) {
            throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage("Failed to serialize the declaration for the artifact [" + artifact.getName() + "]: " + e.getMessage()), (Throwable)e);
        }
    }

    private Document createAppDocument(ArtifactDeclaration artifact) throws ParserConfigurationException {
        DocumentBuilderFactory factory = XMLSecureFactories.createDefault().getDocumentBuilderFactory();
        factory.setNamespaceAware(true);
        DocumentBuilder docBuilder = factory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        Element mule = doc.createElement("mule");
        doc.appendChild(mule);
        artifact.getCustomConfigurationParameters().forEach(p -> mule.setAttribute(p.getName(), p.getValue().toString()));
        if (org.mule.runtime.core.api.util.StringUtils.isBlank(mule.getAttribute(XSI_SCHEMA_LOCATION))) {
            mule.setAttributeNS(XMLNS_W3_URL, XMLNS, DslConstants.CORE_NAMESPACE);
            mule.setAttributeNS(XSI_W3_URL, XSI_SCHEMA_LOCATION, DslConstants.CORE_NAMESPACE + " " + "http://www.mulesoft.org/schema/mule/core/current/mule.xsd");
        }
        return doc;
    }

    private void appendChildElement(XmlDslElementModelConverter converter, Element parent, DslElementModelFactory modelResolver, ElementDeclaration declaration) {
        modelResolver.create(declaration).ifPresent(e -> parent.appendChild(converter.asXml((DslElementModel)e)));
    }

    private List<String> getCDataElements(Node element) {
        if (element.getChildNodes().getLength() == 1 && element.getFirstChild().getNodeType() == 4) {
            return Collections.singletonList(String.format("{%s}%s", element.getNamespaceURI(), element.getLocalName()));
        }
        LinkedList<String> identifiers = new LinkedList<String>();
        NodeList childs = element.getChildNodes();
        IntStream.range(0, childs.getLength()).mapToObj(childs::item).forEach(c -> identifiers.addAll(this.getCDataElements((Node)c)));
        return identifiers;
    }
}

