/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.globalconfig.api;

import com.typesafe.config.Config;
import com.typesafe.config.ConfigFactory;
import com.typesafe.config.ConfigParseOptions;
import com.typesafe.config.ConfigRenderOptions;
import com.typesafe.config.ConfigResolveOptions;
import com.typesafe.config.ConfigSyntax;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.locks.StampedLock;
import java.util.function.Function;
import java.util.function.Supplier;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.api.util.LazyValue;
import org.mule.runtime.globalconfig.api.cluster.ClusterConfig;
import org.mule.runtime.globalconfig.api.exception.RuntimeGlobalConfigException;
import org.mule.runtime.globalconfig.internal.ClusterConfigBuilder;
import org.mule.runtime.globalconfig.internal.MavenConfigBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GlobalConfigLoader {
    private static final String CONFIG_ROOT_ELEMENT_NAME = "muleRuntimeConfig";
    private static final String DEFAULT_MULE_CONFIG_FILE_NAME = "mule-config";
    public static final String MULE_CONFIG_FILE_NAME_PROPERTY = "mule.configFile";
    private static final String CLUSTER_PROPERTY = "cluster";
    private static final String MAVEN_PROPERTY = "maven";
    private static final String JSON_EXTENSION = ".json";
    private static Logger LOGGER = LoggerFactory.getLogger(GlobalConfigLoader.class);
    private static MavenConfiguration mavenConfig;
    private static ClusterConfig clusterConfig;
    private static StampedLock lock;
    private static final String MULE_SCHEMA_JSON_LOCATION = "mule-schema.json";

    private GlobalConfigLoader() {
    }

    private static void initialiseGlobalConfig() {
        Config muleRuntimeConfig;
        String configFileName = System.getProperty(MULE_CONFIG_FILE_NAME_PROPERTY, DEFAULT_MULE_CONFIG_FILE_NAME).replace(JSON_EXTENSION, "");
        Config config = ConfigFactory.load((ClassLoader)GlobalConfigLoader.class.getClassLoader(), (String)configFileName, (ConfigParseOptions)ConfigParseOptions.defaults().setSyntax(ConfigSyntax.JSON), (ConfigResolveOptions)ConfigResolveOptions.defaults());
        Config config2 = muleRuntimeConfig = config.hasPath(CONFIG_ROOT_ELEMENT_NAME) ? config.getConfig(CONFIG_ROOT_ELEMENT_NAME) : null;
        if (muleRuntimeConfig == null) {
            mavenConfig = MavenConfigBuilder.defaultMavenConfig();
            clusterConfig = ClusterConfigBuilder.defaultClusterConfig();
        } else {
            String effectiveConfigAsJson = muleRuntimeConfig.root().render(ConfigRenderOptions.concise().setJson(true).setComments(false));
            LazyValue<Supplier<String>> prettyPrintConfig = new LazyValue<Supplier<String>>(() -> muleRuntimeConfig.root().render(ConfigRenderOptions.defaults().setComments(true).setJson(true).setFormatted(true)));
            try (InputStream schemaStream = GlobalConfigLoader.class.getClassLoader().getResourceAsStream(MULE_SCHEMA_JSON_LOCATION);){
                JSONObject rawSchema = new JSONObject(new JSONTokener(schemaStream));
                Schema schema = SchemaLoader.load((JSONObject)rawSchema);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Using effective mule-config.json configuration: \n" + (String)prettyPrintConfig.get());
                }
                schema.validate((Object)new JSONObject(effectiveConfigAsJson));
                GlobalConfigLoader.parseMavenConfig(muleRuntimeConfig);
                GlobalConfigLoader.parseClusterConfig(muleRuntimeConfig);
            }
            catch (ValidationException e) {
                LOGGER.info(String.format("Mule global config exception. Effective configuration is (config is a merge of MULE_HOME/conf/%s.json and system properties): \n %s", configFileName, prettyPrintConfig.get()));
                throw new RuntimeGlobalConfigException((Exception)((Object)e));
            }
            catch (IOException e) {
                throw new RuntimeGlobalConfigException(I18nMessageFactory.createStaticMessage(String.format("resources %s missing from the runtime classpath", MULE_SCHEMA_JSON_LOCATION)), e);
            }
        }
    }

    private static <T> T parseConfig(Config muleRuntimeConfig, String configProperty, Supplier<T> noConfigCallback, Function<Config, T> parseConfigCallback) {
        Config config;
        Config config2 = config = muleRuntimeConfig.hasPath(configProperty) ? muleRuntimeConfig.getConfig(configProperty) : null;
        if (config == null) {
            return noConfigCallback.get();
        }
        return parseConfigCallback.apply(config);
    }

    private static void parseClusterConfig(Config muleRuntimeConfig) {
        clusterConfig = GlobalConfigLoader.parseConfig(muleRuntimeConfig, CLUSTER_PROPERTY, ClusterConfigBuilder::defaultClusterConfig, ClusterConfigBuilder::parseClusterConfig);
    }

    private static void parseMavenConfig(Config muleRuntimeConfig) {
        mavenConfig = GlobalConfigLoader.parseConfig(muleRuntimeConfig, MAVEN_PROPERTY, MavenConfigBuilder::defaultMavenConfig, MavenConfigBuilder::buildMavenConfig);
    }

    public static void reset() {
        long stamp = lock.writeLock();
        try {
            mavenConfig = null;
            clusterConfig = null;
            ConfigFactory.invalidateCaches();
            GlobalConfigLoader.initialiseGlobalConfig();
        }
        finally {
            lock.unlockWrite(stamp);
        }
    }

    public static MavenConfiguration getMavenConfig() {
        return GlobalConfigLoader.safelyGetConfig(() -> mavenConfig);
    }

    public static ClusterConfig getClusterConfig() {
        return GlobalConfigLoader.safelyGetConfig(() -> clusterConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T safelyGetConfig(Supplier<T> configSupplier) {
        long stamp = lock.readLock();
        try {
            if (configSupplier.get() == null) {
                long writeStamp = lock.tryConvertToWriteLock(stamp);
                if (writeStamp == 0L) {
                    lock.unlockRead(stamp);
                    stamp = lock.writeLock();
                } else {
                    stamp = writeStamp;
                }
                if (configSupplier.get() == null) {
                    GlobalConfigLoader.initialiseGlobalConfig();
                }
            }
            T t = configSupplier.get();
            return t;
        }
        finally {
            lock.unlock(stamp);
        }
    }

    static {
        lock = new StampedLock();
    }
}

