/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.extension.internal.runtime.resolver;

import java.util.Optional;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.connection.ConnectionProvider;
import org.mule.runtime.api.exception.MuleException;
import org.mule.runtime.api.lifecycle.Initialisable;
import org.mule.runtime.api.lifecycle.InitialisationException;
import org.mule.runtime.api.lifecycle.Startable;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.core.api.MuleContext;
import org.mule.runtime.core.api.lifecycle.LifecycleUtils;
import org.mule.runtime.module.extension.internal.runtime.config.ConnectionProviderObjectBuilder;
import org.mule.runtime.module.extension.internal.runtime.resolver.ConnectionProviderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ObjectBuilderValueResolver;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSet;
import org.mule.runtime.module.extension.internal.runtime.resolver.ResolverSetResult;
import org.mule.runtime.module.extension.internal.runtime.resolver.ValueResolvingContext;

public class ConnectionProviderResolver<C>
extends AbstractComponent
implements ConnectionProviderValueResolver<C>,
Initialisable,
Startable {
    private final ConnectionProviderObjectBuilder<C> objectBuilder;
    private final ObjectBuilderValueResolver<Pair<ConnectionProvider<C>, ResolverSetResult>> valueResolver;
    private final ResolverSet resolverSet;

    public ConnectionProviderResolver(ConnectionProviderObjectBuilder<C> objectBuilder, ResolverSet resolverSet, MuleContext muleContext) {
        this.objectBuilder = objectBuilder;
        this.valueResolver = new ObjectBuilderValueResolver<C>(objectBuilder, muleContext);
        this.resolverSet = resolverSet;
    }

    @Override
    public Pair<ConnectionProvider<C>, ResolverSetResult> resolve(ValueResolvingContext context) throws MuleException {
        return this.valueResolver.resolve(context);
    }

    @Override
    public boolean isDynamic() {
        return this.valueResolver.isDynamic();
    }

    @Override
    public Optional<ResolverSet> getResolverSet() {
        return Optional.of(this.resolverSet);
    }

    @Override
    public Optional<ConnectionProviderObjectBuilder<C>> getObjectBuilder() {
        return Optional.of(this.objectBuilder);
    }

    public void setOwnerConfigName(String ownerConfigName) {
        this.objectBuilder.setOwnerConfigName(ownerConfigName);
    }

    @Override
    public void initialise() throws InitialisationException {
        LifecycleUtils.initialiseIfNeeded(this.resolverSet);
    }

    @Override
    public void start() throws MuleException {
        LifecycleUtils.startIfNeeded(this.objectBuilder);
    }
}

