/*
 * Decompiled with CFR 0.152.
 */
package org.mule.service.http.impl.service.client;

import com.ning.http.client.BodyGenerator;
import com.ning.http.client.Realm;
import com.ning.http.client.RequestBuilder;
import com.ning.http.client.generators.InputStreamBodyGenerator;
import com.ning.http.client.multipart.ByteArrayPart;
import com.ning.http.client.multipart.Part;
import com.ning.http.client.providers.grizzly.FeedableBodyGenerator;
import com.ning.http.client.providers.grizzly.NonBlockingInputStreamFeeder;
import com.ning.http.util.UTF8UrlEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.mule.runtime.api.streaming.bytes.CursorStream;
import org.mule.runtime.core.api.util.IOUtils;
import org.mule.runtime.http.api.client.HttpRequestOptions;
import org.mule.runtime.http.api.client.auth.HttpAuthentication;
import org.mule.runtime.http.api.client.auth.HttpAuthenticationType;
import org.mule.runtime.http.api.client.proxy.ProxyConfig;
import org.mule.runtime.http.api.domain.entity.multipart.HttpPart;
import org.mule.runtime.http.api.domain.message.request.HttpRequest;
import org.mule.service.http.impl.service.client.CursorInputStreamBodyGenerator;
import org.mule.service.http.impl.service.client.CursorNonBlockingInputStreamFeeder;
import org.mule.service.http.impl.service.client.GrizzlyHttpClient;

class GrizzlyRequestConfigurer
implements GrizzlyHttpClient.RequestConfigurer {
    private final HttpRequestOptions options;
    private final HttpRequest request;
    private final GrizzlyHttpClient client;
    private final boolean enableMuleRedirect;
    private final boolean requestStreamingEnabled;
    private final int requestStreamingBufferSize;

    GrizzlyRequestConfigurer(GrizzlyHttpClient client, HttpRequestOptions options, HttpRequest request, boolean enableMuleRedirect, boolean requestStreamingEnabled, int requestStreamingBufferSize) {
        this.client = client;
        this.options = options;
        this.request = request;
        this.enableMuleRedirect = enableMuleRedirect;
        this.requestStreamingEnabled = requestStreamingEnabled;
        this.requestStreamingBufferSize = requestStreamingBufferSize;
    }

    @Override
    public void configure(RequestBuilder builder) throws IOException {
        builder.setFollowRedirects(!this.enableMuleRedirect && this.options.isFollowsRedirect());
        this.client.populateHeaders(this.request, builder);
        for (Map.Entry<String, String> entry : this.request.getQueryParams().entryList()) {
            builder.addQueryParam(entry.getKey() != null ? UTF8UrlEncoder.encodeQueryElement((String)entry.getKey()) : null, entry.getValue() != null ? UTF8UrlEncoder.encodeQueryElement((String)entry.getValue()) : null);
        }
        this.options.getAuthentication().ifPresent(authentication -> {
            Realm.RealmBuilder realmBuilder = new Realm.RealmBuilder().setPrincipal(authentication.getUsername()).setPassword(authentication.getPassword()).setUsePreemptiveAuth(authentication.isPreemptive());
            if (authentication.getType() == HttpAuthenticationType.BASIC) {
                realmBuilder.setScheme(Realm.AuthScheme.BASIC);
            } else if (authentication.getType() == HttpAuthenticationType.DIGEST) {
                realmBuilder.setScheme(Realm.AuthScheme.DIGEST);
            } else if (authentication.getType() == HttpAuthenticationType.NTLM) {
                String workstation;
                String domain = ((HttpAuthentication.HttpNtlmAuthentication)authentication).getDomain();
                if (domain != null) {
                    realmBuilder.setNtlmDomain(domain);
                }
                String ntlmHost = (workstation = ((HttpAuthentication.HttpNtlmAuthentication)authentication).getWorkstation()) != null ? workstation : this.client.getHostName();
                realmBuilder.setNtlmHost(ntlmHost).setScheme(Realm.AuthScheme.NTLM);
            }
            builder.setRealm(realmBuilder.build());
        });
        this.options.getProxyConfig().ifPresent(proxyConfig -> builder.setProxyServer(this.client.buildProxy((ProxyConfig)proxyConfig)));
        if (this.request.getEntity() != null) {
            if (this.request.getEntity().isStreaming()) {
                this.setStreamingBodyToRequestBuilder(this.request, builder);
            } else if (this.request.getEntity().isComposed()) {
                for (HttpPart part : this.request.getEntity().getParts()) {
                    if (part.getFileName() != null) {
                        builder.addBodyPart((Part)new ByteArrayPart(part.getName(), IOUtils.toByteArray(part.getInputStream()), part.getContentType(), null, part.getFileName()));
                        continue;
                    }
                    byte[] content = IOUtils.toByteArray(part.getInputStream());
                    builder.addBodyPart((Part)new ByteArrayPart(part.getName(), content, part.getContentType(), null));
                }
            } else {
                builder.setBody(this.request.getEntity().getBytes());
            }
        }
        builder.setRequestTimeout(this.options.getResponseTimeout());
    }

    private void setStreamingBodyToRequestBuilder(HttpRequest request, RequestBuilder builder) throws IOException {
        if (this.requestStreamingEnabled) {
            FeedableBodyGenerator bodyGenerator = new FeedableBodyGenerator();
            bodyGenerator.setFeeder((FeedableBodyGenerator.Feeder)new InputStreamFeederFactory(bodyGenerator, request.getEntity().getContent(), this.requestStreamingBufferSize).getInputStreamFeeder());
            builder.setBody((BodyGenerator)bodyGenerator);
        } else {
            builder.setBody((BodyGenerator)new InputStreamBodyGeneratorFactory(request.getEntity().getContent()).getInputStreamBodyGenerator());
        }
    }

    private static class InputStreamBodyGeneratorFactory {
        private InputStream inputStream;

        public InputStreamBodyGeneratorFactory(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public InputStreamBodyGenerator getInputStreamBodyGenerator() {
            if (this.inputStream instanceof CursorStream) {
                return new CursorInputStreamBodyGenerator((CursorStream)this.inputStream);
            }
            return new InputStreamBodyGenerator(this.inputStream);
        }
    }

    private static class InputStreamFeederFactory {
        private FeedableBodyGenerator feedableBodyGenerator;
        private InputStream content;
        private int internalBufferSize;

        public InputStreamFeederFactory(FeedableBodyGenerator feedableBodyGenerator, InputStream content, int internalBufferSize) {
            this.feedableBodyGenerator = feedableBodyGenerator;
            this.content = content;
            this.internalBufferSize = internalBufferSize;
        }

        public NonBlockingInputStreamFeeder getInputStreamFeeder() {
            if (this.content instanceof CursorStream) {
                return new CursorNonBlockingInputStreamFeeder(this.feedableBodyGenerator, (CursorStream)this.content, this.internalBufferSize);
            }
            return new NonBlockingInputStreamFeeder(this.feedableBodyGenerator, this.content, this.internalBufferSize);
        }
    }
}

